/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.token;

import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsProducer;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenBurnMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenCreateMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenFreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenMintMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenPauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnfreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnpauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenWipeMeta;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TokenBurnTransactionBody;
import com.hederahashgraph.api.proto.java.TokenCreateTransactionBody;
import com.hederahashgraph.api.proto.java.TokenMintTransactionBody;
import com.hederahashgraph.api.proto.java.TokenType;
import com.hederahashgraph.api.proto.java.TokenWipeAccountTransactionBody;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;

public enum TokenOpsUsageUtils {
    TOKEN_OPS_USAGE_UTILS;

    private static final int AMOUNT_REPR_BYTES = 8;

    public TokenCreateMeta tokenCreateUsageFrom(TransactionBody txn) {
        boolean usesCustomFees;
        int baseSize = this.getTokenTxnBaseSize(txn);
        TokenCreateTransactionBody op = txn.getTokenCreation();
        long lifetime = op.hasAutoRenewAccount() ? op.getAutoRenewPeriod().getSeconds() : SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(txn, op.getExpiry().getSeconds());
        lifetime = Math.min(lifetime, 3153600000L);
        TokenOpsUsage tokenOpsUsage = new TokenOpsUsage();
        int feeSchedulesSize = op.getCustomFeesCount() > 0 ? tokenOpsUsage.bytesNeededToRepr(op.getCustomFeesList()) : 0;
        boolean bl = usesCustomFees = op.hasFeeScheduleKey() || op.getCustomFeesCount() > 0;
        SubType chosenType = op.getTokenType() == TokenType.NON_FUNGIBLE_UNIQUE ? (usesCustomFees ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES : SubType.TOKEN_NON_FUNGIBLE_UNIQUE) : (usesCustomFees ? SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES : SubType.TOKEN_FUNGIBLE_COMMON);
        return new TokenCreateMeta.Builder().baseSize(baseSize).lifeTime(lifetime).customFeeScheleSize(feeSchedulesSize).fungibleNumTransfers(op.getInitialSupply() > 0L ? 1 : 0).nftsTranfers(0).numTokens(1).networkRecordRb(24).subType(chosenType).build();
    }

    public TokenMintMeta tokenMintUsageFrom(TransactionBody txn, SubType subType, long expectedLifeTime) {
        TokenMintTransactionBody op = txn.getTokenMint();
        int bpt = 0;
        long rbs = 0L;
        int transferRecordRb = 0;
        if (subType == SubType.TOKEN_NON_FUNGIBLE_UNIQUE) {
            bpt = op.getMetadataList().size();
        } else {
            bpt = 8;
            transferRecordRb = TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(1, 1, 0);
            bpt += 24;
        }
        return new TokenMintMeta(bpt, subType, transferRecordRb, rbs);
    }

    public TokenFreezeMeta tokenFreezeUsageFrom() {
        return new TokenFreezeMeta(48);
    }

    public TokenUnfreezeMeta tokenUnfreezeUsageFrom() {
        return new TokenUnfreezeMeta(48);
    }

    public TokenPauseMeta tokenPauseUsageFrom() {
        return new TokenPauseMeta(24);
    }

    public TokenUnpauseMeta tokenUnpauseUsageFrom() {
        return new TokenUnpauseMeta(24);
    }

    public TokenBurnMeta tokenBurnUsageFrom(TransactionBody txn) {
        TokenBurnTransactionBody op = txn.getTokenBurn();
        SubType subType = op.getSerialNumbersCount() > 0 ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE : SubType.TOKEN_FUNGIBLE_COMMON;
        return this.tokenBurnUsageFrom(txn, subType);
    }

    public TokenBurnMeta tokenBurnUsageFrom(TransactionBody txn, SubType subType) {
        TokenBurnTransactionBody op = txn.getTokenBurn();
        return this.retrieveRawDataFrom(subType, () -> ((TokenBurnTransactionBody)op).getSerialNumbersCount(), TokenBurnMeta::new);
    }

    public TokenWipeMeta tokenWipeUsageFrom(TransactionBody txn) {
        TokenWipeAccountTransactionBody op = txn.getTokenWipe();
        SubType subType = op.getSerialNumbersCount() > 0 ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE : SubType.TOKEN_FUNGIBLE_COMMON;
        return this.tokenWipeUsageFrom(op, subType);
    }

    public TokenWipeMeta tokenWipeUsageFrom(TokenWipeAccountTransactionBody op) {
        SubType subType = op.getSerialNumbersCount() > 0 ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE : SubType.TOKEN_FUNGIBLE_COMMON;
        return this.tokenWipeUsageFrom(op, subType);
    }

    public TokenWipeMeta tokenWipeUsageFrom(TokenWipeAccountTransactionBody op, SubType subType) {
        return this.retrieveRawDataFrom(subType, () -> ((TokenWipeAccountTransactionBody)op).getSerialNumbersCount(), TokenWipeMeta::new);
    }

    public <R> R retrieveRawDataFrom(SubType subType, IntSupplier getDataForNFT, TokenOpsProducer<R> producer) {
        int serialNumsCount = 0;
        int bpt = 0;
        int transferRecordRb = 0;
        if (subType == SubType.TOKEN_NON_FUNGIBLE_UNIQUE) {
            serialNumsCount = getDataForNFT.getAsInt();
            transferRecordRb = TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(1, 0, serialNumsCount);
            bpt = serialNumsCount * 8;
        } else {
            bpt = 8;
            transferRecordRb = TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(1, 1, 0);
        }
        return producer.create(bpt += 24, subType, transferRecordRb, serialNumsCount);
    }

    public int getTokenTxnBaseSize(TransactionBody txn) {
        TokenCreateTransactionBody op = txn.getTokenCreation();
        TokenEntitySizes tokenEntitySizes = TokenEntitySizes.TOKEN_ENTITY_SIZES;
        int baseSize = tokenEntitySizes.totalBytesInTokenReprGiven(op.getSymbol(), op.getName());
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasKycKey, TokenCreateTransactionBody::getKycKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasWipeKey, TokenCreateTransactionBody::getWipeKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasAdminKey, TokenCreateTransactionBody::getAdminKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasSupplyKey, TokenCreateTransactionBody::getSupplyKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasFreezeKey, TokenCreateTransactionBody::getFreezeKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasFeeScheduleKey, TokenCreateTransactionBody::getFeeScheduleKey);
        baseSize += TokenOpsUsageUtils.keySizeIfPresent(op, TokenCreateTransactionBody::hasPauseKey, TokenCreateTransactionBody::getPauseKey);
        baseSize += op.getMemoBytes().size();
        if (op.hasAutoRenewAccount()) {
            baseSize += 24;
        }
        return baseSize;
    }

    public static <T> int keySizeIfPresent(T body, Predicate<T> check, Function<T, Key> getter) {
        return check.test(body) ? FeeBuilder.getAccountKeyStorageSize((Key)getter.apply(body)) : 0;
    }
}

