/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.token.NodeActivity;
import com.hedera.hapi.node.state.token.NodeRewards;
import com.hedera.node.app.service.token.ReadableNodeRewardsStore;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReadableNodeRewardsStoreImpl
implements ReadableNodeRewardsStore {
    private final ReadableSingletonState<NodeRewards> nodeRewardsState;

    public ReadableNodeRewardsStoreImpl(@NonNull ReadableStates states) {
        this.nodeRewardsState = Objects.requireNonNull(states).getSingleton("NODE_REWARDS");
    }

    public NodeRewards get() {
        return Objects.requireNonNull((NodeRewards)this.nodeRewardsState.get());
    }

    public List<Long> getActiveNodeIds(@NonNull List<RosterEntry> rosterEntries, int minJudgeRoundPercentage) {
        Objects.requireNonNull(rosterEntries);
        long roundsLastPeriod = Objects.requireNonNull((NodeRewards)this.nodeRewardsState.get()).numRoundsInStakingPeriod();
        long maxMissedJudges = BigInteger.valueOf(roundsLastPeriod).multiply(BigInteger.valueOf(100 - minJudgeRoundPercentage)).divide(BigInteger.valueOf(100L)).longValueExact();
        Map<Long, Long> missedJudgeCounts = this.get().nodeActivities().stream().collect(Collectors.toMap(NodeActivity::nodeId, NodeActivity::numMissedJudgeRounds));
        return rosterEntries.stream().map(RosterEntry::nodeId).filter(nodeId -> missedJudgeCounts.getOrDefault(nodeId, 0L) <= maxMissedJudges).toList();
    }
}

