/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.CustomFee;

public final class CustomFeeExemptions {
    private CustomFeeExemptions() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static boolean isPayerExempt(Token token, CustomFee fee, AccountID sender) {
        if (token.treasuryAccountIdOrThrow().equals((Object)sender)) {
            return true;
        }
        if (fee.feeCollectorAccountIdOrElse(AccountID.DEFAULT).equals((Object)sender)) {
            return true;
        }
        if (fee.allCollectorsAreExempt()) {
            return CustomFeeExemptions.isPayerCollectorFor(token, sender);
        }
        return false;
    }

    private static boolean isPayerCollectorFor(Token token, AccountID sender) {
        for (CustomFee fee : token.customFees()) {
            if (!fee.feeCollectorAccountIdOrElse(AccountID.DEFAULT).equals((Object)sender)) continue;
            return true;
        }
        return false;
    }
}

