/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import io.helidon.common.uri.UriEncoding;
import io.helidon.common.uri.UriQuery;
import io.helidon.common.uri.UriValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class UriQueryImpl
implements UriQuery {
    private final String query;
    private Map<String, List<String>> rawQueryParams;
    private Map<String, List<String>> decodedQueryParams;

    UriQueryImpl(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriQuery)) {
            return false;
        }
        UriQuery that = (UriQuery)o;
        if (!Objects.equals(this.names(), that.names())) {
            return false;
        }
        for (String name : this.names()) {
            if (Objects.equals(this.all(name), that.all(name))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        this.ensureDecoded();
        return Objects.hashCode(this.decodedQueryParams);
    }

    @Override
    public String rawValue() {
        return this.query;
    }

    @Override
    public String value() {
        this.ensureDecoded();
        if (this.decodedQueryParams.isEmpty()) {
            return "";
        }
        ArrayList params = new ArrayList(this.decodedQueryParams.size());
        this.decodedQueryParams.forEach((name, values) -> params.add(name + "=" + String.join((CharSequence)",", values)));
        return String.join((CharSequence)"&", params);
    }

    @Override
    public String getRaw(String name) throws NoSuchElementException {
        this.ensureRaw();
        List<String> values = this.rawQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.isEmpty() ? "" : values.iterator().next();
    }

    @Override
    public List<String> getAllRaw(String name) throws NoSuchElementException {
        this.ensureRaw();
        List<String> values = this.rawQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values;
    }

    public List<String> all(String name) throws NoSuchElementException {
        this.ensureDecoded();
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values;
    }

    public List<Value<String>> allValues(String name) throws NoSuchElementException {
        this.ensureDecoded();
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.stream().map(it -> Value.create((Mappers)MapperManager.global(), (String)name, (Object)it, (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"})).collect(Collectors.toList());
    }

    public String get(String name) throws NoSuchElementException {
        this.ensureDecoded();
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.isEmpty() ? "" : values.iterator().next();
    }

    public OptionalValue<String> first(String name) {
        this.ensureDecoded();
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null || values.isEmpty()) {
            return OptionalValue.create((Mappers)MapperManager.global(), (String)name, (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"});
        }
        return OptionalValue.create((Mappers)MapperManager.global(), (String)name, (Object)values.iterator().next(), (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"});
    }

    public boolean contains(String name) {
        this.ensureDecoded();
        return this.decodedQueryParams.containsKey(name);
    }

    public boolean isEmpty() {
        return false;
    }

    public int size() {
        this.ensureDecoded();
        return this.decodedQueryParams.size();
    }

    public Set<String> names() {
        this.ensureDecoded();
        return this.decodedQueryParams.keySet();
    }

    public String component() {
        return "uri-query";
    }

    public String toString() {
        return "?" + this.rawValue();
    }

    UriQuery validate() {
        UriValidator.validateQuery(this.query);
        return this;
    }

    private void ensureDecoded() {
        if (this.decodedQueryParams == null) {
            HashMap<String, List<String>> newQueryParams = new HashMap<String, List<String>>();
            String remaining = this.query;
            while (true) {
                int and;
                if ((and = remaining.indexOf(38)) == -1) break;
                String next = remaining.substring(0, and);
                remaining = remaining.substring(and + 1);
                this.addDecoded(newQueryParams, next);
            }
            this.addDecoded(newQueryParams, remaining);
            this.decodedQueryParams = newQueryParams;
        }
    }

    private void addDecoded(Map<String, List<String>> newQueryParams, String next) {
        int eq = next.indexOf(61);
        if (eq == -1) {
            newQueryParams.putIfAbsent(UriEncoding.decodeQuery(next), new LinkedList());
        } else {
            String name = next.substring(0, eq);
            String value = next.substring(eq + 1);
            newQueryParams.computeIfAbsent(UriEncoding.decodeQuery(name), it -> new LinkedList()).add(UriEncoding.decodeQuery(value));
        }
    }

    private void ensureRaw() {
        if (this.rawQueryParams == null) {
            HashMap<String, List<String>> newQueryParams = new HashMap<String, List<String>>();
            String remaining = this.query;
            while (true) {
                int and;
                if ((and = remaining.indexOf(38)) == -1) break;
                String next = remaining.substring(0, and);
                remaining = remaining.substring(and + 1);
                this.addRaw(newQueryParams, next);
            }
            this.addRaw(newQueryParams, remaining);
            this.rawQueryParams = newQueryParams;
        }
    }

    private void addRaw(Map<String, List<String>> newQueryParams, String next) {
        int eq = next.indexOf(61);
        if (eq == -1) {
            newQueryParams.putIfAbsent(next, new LinkedList());
        } else {
            String name = next.substring(0, eq);
            String value = next.substring(eq + 1);
            newQueryParams.computeIfAbsent(name, it -> new LinkedList()).add(value);
        }
    }
}

