/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractCreateOperation
extends AbstractOperation {
    protected static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    protected int maxInitcodeSize;

    protected AbstractCreateOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator, int maxInitcodeSize) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
        this.maxInitcodeSize = maxInitcodeSize;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        if (frame.stackSize() < this.getStackItemsConsumed()) {
            return UNDERFLOW_RESPONSE;
        }
        long cost = this.cost(frame);
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        Address address = frame.getRecipientAddress();
        MutableAccount account = frame.getWorldUpdater().getAccount(address);
        frame.clearReturnData();
        long inputOffset = Words.clampedToLong(frame.getStackItem(1));
        long inputSize = Words.clampedToLong(frame.getStackItem(2));
        if (inputSize > (long)this.maxInitcodeSize) {
            frame.popStackItems(this.getStackItemsConsumed());
            return new Operation.OperationResult(cost, ExceptionalHaltReason.CODE_TOO_LARGE);
        }
        if (value.compareTo((Bytes)account.getBalance()) > 0 || frame.getDepth() >= 1024 || account.getNonce() == -1L) {
            this.fail(frame);
        } else {
            account.incrementNonce();
            Bytes inputData = frame.readMemory(inputOffset, inputSize);
            Code code = evm.getCode(null, inputData);
            if (code.isValid() && frame.getCode().getEofVersion() <= code.getEofVersion()) {
                frame.decrementRemainingGas(cost);
                this.spawnChildMessage(frame, code, evm);
                frame.incrementRemainingGas(cost);
            } else {
                this.fail(frame);
            }
        }
        return new Operation.OperationResult(cost, null);
    }

    protected abstract long cost(MessageFrame var1);

    protected abstract Address targetContractAddress(MessageFrame var1);

    private void fail(MessageFrame frame) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(1));
        long inputSize = Words.clampedToLong(frame.getStackItem(2));
        frame.readMutableMemory(inputOffset, inputSize);
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem(FAILURE_STACK_ITEM);
    }

    private void spawnChildMessage(MessageFrame parent, Code code, EVM evm) {
        Wei value = Wei.wrap((Bytes)parent.getStackItem(0));
        Address contractAddress = this.targetContractAddress(parent);
        long childGasStipend = this.gasCalculator().gasAvailableForChildCreate(parent.getRemainingGas());
        parent.decrementRemainingGas(childGasStipend);
        MessageFrame.builder().parentMessageFrame(parent).type(MessageFrame.Type.CONTRACT_CREATION).initialGas(childGasStipend).address(contractAddress).contract(contractAddress).inputData(Bytes.EMPTY).sender(parent.getRecipientAddress()).value(value).apparentValue(value).code(code).completer(child -> this.complete(parent, (MessageFrame)child, evm)).build();
        parent.setState(MessageFrame.State.CODE_SUSPENDED);
    }

    private void complete(MessageFrame frame, MessageFrame childFrame, EVM evm) {
        frame.setState(MessageFrame.State.CODE_EXECUTING);
        Code outputCode = CodeFactory.createCode(childFrame.getOutputData(), evm.getMaxEOFVersion(), true);
        frame.popStackItems(this.getStackItemsConsumed());
        if (outputCode.isValid()) {
            frame.incrementRemainingGas(childFrame.getRemainingGas());
            frame.addLogs(childFrame.getLogs());
            frame.addSelfDestructs(childFrame.getSelfDestructs());
            frame.addCreates(childFrame.getCreates());
            frame.incrementGasRefund(childFrame.getGasRefund());
            if (childFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
                Address createdAddress = childFrame.getContractAddress();
                frame.pushStackItem((Bytes)Words.fromAddress(createdAddress));
                this.onSuccess(frame, createdAddress);
            } else {
                frame.setReturnData(childFrame.getOutputData());
                frame.pushStackItem(FAILURE_STACK_ITEM);
                this.onFailure(frame, childFrame.getExceptionalHaltReason());
            }
        } else {
            frame.getWorldUpdater().deleteAccount(childFrame.getRecipientAddress());
            frame.setReturnData(childFrame.getOutputData());
            frame.pushStackItem(FAILURE_STACK_ITEM);
            this.onInvalid(frame, (CodeInvalid)outputCode);
        }
        int currentPC = frame.getPC();
        frame.setPC(currentPC + 1);
    }

    protected void onSuccess(MessageFrame frame, Address createdAddress) {
    }

    protected void onFailure(MessageFrame frame, Optional<ExceptionalHaltReason> haltReason) {
    }

    protected void onInvalid(MessageFrame frame, CodeInvalid invalidCode) {
    }
}

