/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.client.helidon;

import com.hedera.pbj.grpc.client.helidon.PbjGrpcCall;
import com.hedera.pbj.grpc.client.helidon.PbjGrpcClientConfig;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.DefaultDnsResolver;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http2.Http2Client;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.spi.DnsResolver;
import java.util.Collections;
import java.util.Optional;

public final class PbjGrpcClient
implements GrpcClient {
    private final WebClient webClient;
    private final PbjGrpcClientConfig config;
    private final Http2Client http2Client;

    public PbjGrpcClient(WebClient webClient, PbjGrpcClientConfig config) {
        this.webClient = webClient;
        this.config = config;
        this.http2Client = (Http2Client)webClient.client(Http2Client.PROTOCOL);
    }

    public <RequestT, ReplyT> GrpcCall<RequestT, ReplyT> createCall(String fullMethodName, Codec<RequestT> requestCodec, Codec<ReplyT> replyCodec, Pipeline<ReplyT> pipeline) {
        ClientConnection clientConnection = this.createClientConnection();
        return new PbjGrpcCall<RequestT, ReplyT>(this, clientConnection, new Options(this.config.authority(), this.config.contentType()), fullMethodName, requestCodec, replyCodec, pipeline);
    }

    WebClient getWebClient() {
        return this.webClient;
    }

    Http2Client getHttp2Client() {
        return this.http2Client;
    }

    public PbjGrpcClientConfig getConfig() {
        return this.config;
    }

    private ClientConnection createClientConnection() {
        ClientUri clientUri = (ClientUri)((Http2ClientImpl)this.http2Client).prototype().baseUri().orElseThrow(() -> new IllegalStateException("No base URI provided in the WebClient."));
        ConnectionKey connectionKey = new ConnectionKey(clientUri.scheme(), clientUri.host(), clientUri.port(), this.config.readTimeout(), this.config.tls(), (DnsResolver)DefaultDnsResolver.create(), DnsAddressLookup.defaultLookup(), Proxy.noProxy());
        return TcpClientConnection.create((WebClient)this.webClient, (ConnectionKey)connectionKey, Collections.emptyList(), connection -> false, connection -> {}).connect();
    }

    private record Options(Optional<String> authority, String contentType) implements ServiceInterface.RequestOptions
    {
    }
}

