/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.units;

import com.swirlds.common.units.Unit;
import com.swirlds.common.units.internal.UnitConverter;

public enum TimeUnit implements Unit<TimeUnit>
{
    UNIT_NANOSECONDS(1, "nanosecond", "ns"),
    UNIT_MICROSECONDS(1000, "microsecond", "us"),
    UNIT_MILLISECONDS(1000, "millisecond", "ms"),
    UNIT_SECONDS(1000, "second", "s"),
    UNIT_MINUTES(60, "minute", "m"),
    UNIT_HOURS(60, "hour", "h"),
    UNIT_DAYS(24, "day", "d");

    private static final UnitConverter<TimeUnit> converter;
    private final int conversionFactor;
    private final String name;
    private final String abbreviation;

    private TimeUnit(int conversionFactor, String name, String abbreviation) {
        this.conversionFactor = conversionFactor;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @Override
    public Unit.SimplifiedQuantity<TimeUnit> simplify(double quantity) {
        return converter.simplify(quantity, this);
    }

    @Override
    public double convertTo(double quantity, TimeUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public double convertTo(long quantity, TimeUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public int getConversionFactor() {
        return this.conversionFactor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPluralName() {
        return this.name + "s";
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    static {
        converter = new UnitConverter((Unit[])TimeUnit.values());
    }
}

