/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class LoggingProxy
implements InvocationHandler {
    private static final Log.Level LOG_LEVEL = Log.Level.OK;
    private static final Log _log = Log.getLog(LoggingProxy.class);
    private final Object _target;
    private final Class<? extends APIOperation> _op;

    public LoggingProxy(Class<? extends APIOperation> api, Object target) {
        this._op = api;
        this._target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this._target, args);
        }
        String methodName = method.getName();
        if (_log.isLoggable(LOG_LEVEL)) {
            StringBuilder bld = new StringBuilder();
            bld.append("Enter: ").append(method.getName()).append('(');
            for (int i = 0; args != null && i < args.length; ++i) {
                if (i != 0) {
                    bld.append(", ");
                }
                bld.append(args[i]);
            }
            bld.append(')');
            String msg = bld.toString();
            _log.log(this._op, methodName, LOG_LEVEL, msg, null);
        }
        try {
            Object ret = method.invoke(this._target, args);
            if (_log.isLoggable(LOG_LEVEL)) {
                _log.log(this._op, methodName, LOG_LEVEL, "Return: " + ret, null);
            }
            return ret;
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getCause();
            try {
                _log.log(this._op, methodName, LOG_LEVEL, "Exception: ", root);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            if (root instanceof Exception) {
                throw (Exception)root;
            }
            if (root instanceof Error) {
                throw (Error)root;
            }
            throw ConnectorException.wrap((Throwable)root);
        }
    }
}

