/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorized;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorized.IsAuthorizedTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SignatureMapUtils;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Function;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class IsAuthorizedCall
extends AbstractCall {
    private final Address address;
    private final byte[] message;
    private final byte[] signatureBlob;
    private final CustomGasCalculator customGasCalculator;
    private final SignatureVerifier signatureVerifier;

    public IsAuthorizedCall(@NonNull HasCallAttempt attempt, Address address, @NonNull byte[] message, @NonNull byte[] signatureBlob, @NonNull CustomGasCalculator gasCalculator) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.address = Objects.requireNonNull(address, "address");
        this.message = Objects.requireNonNull(message, "message");
        this.signatureBlob = Objects.requireNonNull(signatureBlob, "signatureBlob");
        this.customGasCalculator = Objects.requireNonNull(gasCalculator, "gasCalculator");
        this.signatureVerifier = Objects.requireNonNull(attempt.signatureVerifier());
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        SignatureMap sigMap;
        Function<ResponseCodeEnum, Call.PricedResult> bail = rce -> this.encodedOutput((ResponseCodeEnum)rce, false, frame.getRemainingGas());
        long accountNum = ConversionUtils.accountNumberForEvmReference(this.address, this.nativeOperations());
        if (!this.isValidAccount(accountNum)) {
            return bail.apply(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        Account account = Objects.requireNonNull(this.enhancement.nativeOperations().getAccount(this.enhancement.nativeOperations().entityIdFactory().newAccountId(accountNum)));
        Key key = account.key();
        if (key == null) {
            return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        try {
            sigMap = Objects.requireNonNull((SignatureMap)SignatureMap.PROTOBUF.parse(Bytes.wrap((byte[])this.signatureBlob)));
        }
        catch (ParseException | NullPointerException ex) {
            return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        sigMap = SignatureMapUtils.stripRecoveryIdFromEcdsaSignatures(sigMap);
        SignatureVerifier.KeyCounts keyCounts = this.signatureVerifier.countSimpleKeys(key);
        long gasRequirement = (long)keyCounts.numEcdsaKeys() * this.customGasCalculator.getEcrecPrecompiledContractGasCost() + (long)keyCounts.numEddsaKeys() * this.customGasCalculator.getEdSignatureVerificationSystemContractGasCost();
        boolean authorized = this.verifyMessage(key, Bytes.wrap((byte[])this.message), SignatureVerifier.MessageType.RAW, sigMap, ky -> SignatureVerifier.SimpleKeyStatus.ONLY_IF_CRYPTO_SIG_VALID);
        return this.encodedOutput(ResponseCodeEnum.SUCCESS, authorized, gasRequirement);
    }

    protected boolean verifyMessage(@NonNull Key key, @NonNull Bytes message, @NonNull SignatureVerifier.MessageType msgType, @NonNull SignatureMap signatureMap, @NonNull Function<Key, SignatureVerifier.SimpleKeyStatus> keyHandlingHook) {
        return this.signatureVerifier.verifySignature(key, message, msgType, signatureMap, keyHandlingHook);
    }

    @NonNull
    protected Call.PricedResult encodedOutput(ResponseCodeEnum rce, boolean authorized, long gasRequirement) {
        long code = rce.protoOrdinal();
        ByteBuffer output = IsAuthorizedTranslator.IS_AUTHORIZED.getOutputs().encode((Object)Tuple.of((Object)code, (Object)authorized));
        return Call.PricedResult.gasOnly(FullResult.successResult(output, gasRequirement), ResponseCodeEnum.SUCCESS, true);
    }

    boolean isValidAccount(long accountNum) {
        return accountNum >= 0L;
    }
}

