/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorizedraw;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorizedraw.IsAuthorizedRawTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SignatureMapUtils;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class IsAuthorizedRawCall
extends AbstractCall {
    private static final int EIP_155_V_MIN_LENGTH = 1;
    private static final int EIP_155_V_MAX_LENGTH = 8;
    private static final int EC_SIGNATURE_WITHOUT_V_LENGTH = 64;
    public static final int EC_SIGNATURE_MIN_LENGTH = 65;
    public static final int EC_SIGNATURE_MAX_LENGTH = 72;
    public static final int ED_SIGNATURE_LENGTH = 64;
    private final Address address;
    private final byte[] messageHash;
    private final byte[] signature;
    private final CustomGasCalculator customGasCalculator;
    private final SignatureVerifier signatureVerifier;

    public IsAuthorizedRawCall(@NonNull HasCallAttempt attempt, Address address, @NonNull byte[] messageHash, @NonNull byte[] signature, @NonNull CustomGasCalculator customGasCalculator) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), true);
        this.address = Objects.requireNonNull(address);
        this.messageHash = Objects.requireNonNull(messageHash);
        this.signature = Objects.requireNonNull(signature);
        this.customGasCalculator = Objects.requireNonNull(customGasCalculator);
        this.signatureVerifier = Objects.requireNonNull(attempt.signatureVerifier());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        Optional<Object> key;
        Objects.requireNonNull(frame, "frame");
        SignatureType signatureType = this.signatureTypeFromItsLength(this.signature);
        long gasRequirement = switch (signatureType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.customGasCalculator.getEcrecPrecompiledContractGasCost();
            case 2 -> this.customGasCalculator.getEdSignatureVerificationSystemContractGasCost();
            case 0 -> Math.min(this.customGasCalculator.getEcrecPrecompiledContractGasCost(), this.customGasCalculator.getEdSignatureVerificationSystemContractGasCost());
        };
        Function<ResponseCodeEnum, Call.PricedResult> bail = rce -> this.reversionWith((ResponseCodeEnum)rce, frame.getRemainingGas());
        if (signatureType == SignatureType.INVALID) {
            return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        long availableGas = frame.getRemainingGas();
        if (availableGas < gasRequirement) {
            return bail.apply(ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        switch (signatureType.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                if (this.messageHash.length != 32) return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)signatureType));
            }
        }
        long accountNum = ConversionUtils.accountNumberForEvmReference(this.address, this.nativeOperations());
        if (!this.isValidAccount(accountNum, signatureType)) {
            return bail.apply(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        Account account = Objects.requireNonNull(this.enhancement.nativeOperations().getAccount(this.enhancement.nativeOperations().entityIdFactory().newAccountId(accountNum)));
        if (signatureType == SignatureType.ED) {
            key = Optional.ofNullable(account.key());
            if (key.isEmpty()) {
                return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            }
        } else {
            key = Optional.empty();
        }
        if (key.isPresent()) {
            boolean keyIsSimple;
            Key ky = (Key)key.get();
            boolean bl = keyIsSimple = !ky.hasKeyList() && !ky.hasThresholdKey();
            if (!keyIsSimple) {
                return bail.apply(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            }
            switch (signatureType.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: {
                    if (!((Key)key.get()).hasEcdsaSecp256k1()) return bail.apply(ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY);
                    break;
                }
                case 2: {
                    if (!((Key)key.get()).hasEd25519()) return bail.apply(ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY);
                    break;
                }
                case 0: {
                    return bail.apply(ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY);
                }
            }
        }
        boolean authorized = switch (signatureType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.validateEcSignature(account);
            case 2 -> this.validateEdSignature(account, (Key)key.get());
            case 0 -> false;
        };
        return Call.PricedResult.gasOnly(FullResult.successResult(this.encodedAuthorizationOutput(authorized), gasRequirement), ResponseCodeEnum.SUCCESS, true);
    }

    public boolean validateEcSignature(Account account) {
        Objects.requireNonNull(account, "account");
        if (account.key() == null || !account.key().hasEcdsaSecp256k1()) {
            return false;
        }
        SignatureMap signatureMap = SignatureMap.newBuilder().sigPair(new SignaturePair[]{SignaturePair.newBuilder().pubKeyPrefix(account.key().ecdsaSecp256k1()).ecdsaSecp256k1(Bytes.wrap((byte[])this.signature)).build()}).build();
        signatureMap = SignatureMapUtils.stripRecoveryIdFromEcdsaSignatures(signatureMap);
        return this.signatureVerifier.verifySignature(account.key(), Bytes.wrap((byte[])this.messageHash), SignatureVerifier.MessageType.KECCAK_256_HASH, signatureMap, ky -> SignatureVerifier.SimpleKeyStatus.ONLY_IF_CRYPTO_SIG_VALID);
    }

    public boolean validateEdSignature(@NonNull Account account, @NonNull Key key) {
        Objects.requireNonNull(account, "account");
        Objects.requireNonNull(key, "key");
        if (account.key() == null || !account.key().hasEd25519()) {
            return false;
        }
        SignatureMap signatureMap = SignatureMap.newBuilder().sigPair(new SignaturePair[]{SignaturePair.newBuilder().pubKeyPrefix(key.ed25519()).ed25519(Bytes.wrap((byte[])this.signature)).build()}).build();
        return this.signatureVerifier.verifySignature(key, Bytes.wrap((byte[])this.messageHash), SignatureVerifier.MessageType.KECCAK_256_HASH, signatureMap, ky -> SignatureVerifier.SimpleKeyStatus.ONLY_IF_CRYPTO_SIG_VALID);
    }

    @NonNull
    ByteBuffer encodedAuthorizationOutput(boolean authorized) {
        return IsAuthorizedRawTranslator.IS_AUTHORIZED_RAW.getOutputs().encode((Object)Tuple.singleton((Object)authorized));
    }

    public boolean isValidAccount(long accountNum, @NonNull SignatureType signatureType) {
        Objects.requireNonNull(signatureType, "signatureType");
        if (accountNum < 0L) {
            return false;
        }
        if (signatureType == SignatureType.EC) {
            return !ConversionUtils.isLongZero(this.address);
        }
        return true;
    }

    @NonNull
    private SignatureType signatureTypeFromItsLength(@NonNull byte[] signature) {
        int len = signature.length;
        if (65 <= len && len <= 72) {
            return SignatureType.EC;
        }
        if (64 == len) {
            return SignatureType.ED;
        }
        return SignatureType.INVALID;
    }

    public static enum SignatureType {
        INVALID,
        EC,
        ED;

    }
}

