/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public class ReturnTypes {
    public static final AccountID ZERO_ACCOUNT_ID = AccountID.newBuilder().accountNum(0L).build();
    public static final Address ZERO_ADDRESS = ConversionUtils.asHeadlongAddress(new byte[20]);
    public static final ContractID ZERO_CONTRACT_ID = ContractID.newBuilder().contractNum(0L).build();
    public static final TokenID ZERO_TOKEN_ID = TokenID.newBuilder().tokenNum(0L).build();
    public static final Fraction ZERO_FRACTION = new Fraction(0L, 1L);
    public static final FixedFee ZERO_FIXED_FEE = new FixedFee(0L, null);
    protected static final String TOKEN_FIELDS = "string,string,address,string,bool,int64,bool,";
    protected static final String TOKEN_KEYS = "(uint256,(bool,address,bytes,bytes,address))[],";
    protected static final String EXPIRY_FIELDS = "(uint32,address,uint32)";
    protected static final String EXPIRY_FIELDS_V2 = "(int64,address,int64)";
    protected static final String CUSTOM_FEES = "(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[]";
    protected static final String STATUS_FIELDS = ",int64,bool,bool,bool,";
    public static final String INT = "(int)";
    public static final String INT_64 = "(int64)";
    public static final String INT64_INT64 = "(int64,int64)";
    public static final String BYTE = "(uint8)";
    public static final String BOOL = "(bool)";
    public static final String STRING = "(string)";
    public static final String ADDRESS = "(address)";
    public static final String RESPONSE_CODE_BOOL = "(int32,bool)";
    public static final String RESPONSE_CODE64_BOOL = "(int64,bool)";
    public static final String RESPONSE_CODE_INT32 = "(int32,int32)";
    public static final String RESPONSE_CODE_UINT256 = "(int64,uint256)";
    public static final String RESPONSE_CODE_INT256 = "(int64,int256)";
    public static final String RESPONSE_CODE_ADDRESS = "(int64,address)";
    public static final String UINT256 = "(uint256)";
    public static final String RESPONSE_CODE_EXPIRY = "(int32,(int64,address,int64))";
    public static final String RESPONSE_CODE_TOKEN_KEY = "(int32,(bool,address,bytes,bytes,address))";
    public static final String RESPONSE_CODE_TOKEN_INFO = "(int32,((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string))";
    public static final String RESPONSE_CODE_TOKEN_INFO_V2 = "(int32,((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(int64,address,int64),bytes),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string))";
    public static final String RESPONSE_CODE_FUNGIBLE_TOKEN_INFO = "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int32))";
    public static final String RESPONSE_CODE_FUNGIBLE_TOKEN_INFO_V2 = "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(int64,address,int64),bytes),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int32))";
    public static final String RESPONSE_CODE_NON_FUNGIBLE_TOKEN_INFO = "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int64,address,int64,bytes,address))";
    public static final String RESPONSE_CODE_NON_FUNGIBLE_TOKEN_INFO_V2 = "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(int64,address,int64),bytes),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int64,address,int64,bytes,address))";
    public static final String RESPONSE_CODE_CUSTOM_FEES = "(int32,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[])";
    public static final TupleType<Tuple> RC_AND_ADDRESS_ENCODER = TupleType.parse((String)"(int64,address)");
    private static final TupleType<Tuple> RC_ENCODER = TupleType.parse((String)"(int64)");

    private ReturnTypes() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Bytes tuweniEncodedRc(@NonNull ResponseCodeEnum status) {
        return Bytes.wrap((byte[])ReturnTypes.encodedRc(status).array());
    }

    public static ByteBuffer encodedRc(@NonNull ResponseCodeEnum status) {
        return RC_ENCODER.encode((Object)Tuple.singleton((Object)status.protoOrdinal()));
    }

    public static ResponseCodeEnum standardized(@NonNull ResponseCodeEnum status) {
        return Objects.requireNonNull(status) == ResponseCodeEnum.INVALID_SIGNATURE ? ResponseCodeEnum.INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE : status;
    }
}

