/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.units.DataUnit;
import com.swirlds.common.utility.LongRunningAverage;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFileManager;
import com.swirlds.platform.event.preconsensus.PcesFileWriterType;
import com.swirlds.platform.event.preconsensus.PcesMutableFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class CommonPcesWriter {
    private static final Logger logger = LogManager.getLogger(CommonPcesWriter.class);
    private final PcesFileManager fileManager;
    private PcesMutableFile currentMutableFile;
    private long nonAncientBoundary = 0L;
    private final int preferredFileSizeMegabytes;
    private final int minimumSpan;
    private long minimumAncientIdentifierToStore;
    private final LongRunningAverage averageSpanUtilization;
    private long previousSpan;
    private boolean bootstrapMode = true;
    private final double bootstrapSpanOverlapFactor;
    private final double spanOverlapFactor;
    private boolean streamingNewEvents = false;
    private final PcesFileWriterType pcesFileWriterType;

    public CommonPcesWriter(@NonNull PlatformContext platformContext, @NonNull PcesFileManager fileManager) {
        Objects.requireNonNull(platformContext, "platformContext is required");
        this.fileManager = Objects.requireNonNull(fileManager, "fileManager is required");
        PcesConfig pcesConfig = (PcesConfig)platformContext.getConfiguration().getConfigData(PcesConfig.class);
        this.previousSpan = pcesConfig.bootstrapSpan();
        this.bootstrapSpanOverlapFactor = pcesConfig.bootstrapSpanOverlapFactor();
        this.spanOverlapFactor = pcesConfig.spanOverlapFactor();
        this.minimumSpan = pcesConfig.minimumSpan();
        this.preferredFileSizeMegabytes = pcesConfig.preferredFileSizeMegabytes();
        this.pcesFileWriterType = System.getProperty("os.name").toLowerCase().contains("mac") ? pcesConfig.macPcesFileWriterType() : pcesConfig.pcesFileWriterType();
        this.averageSpanUtilization = new LongRunningAverage(pcesConfig.spanUtilizationRunningAverageLength());
    }

    public void beginStreamingNewEvents() {
        if (this.streamingNewEvents) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "beginStreamingNewEvents() called while already streaming new events");
        }
        this.streamingNewEvents = true;
    }

    public boolean registerDiscontinuity(@NonNull Long newOriginRound) {
        if (!this.streamingNewEvents) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "registerDiscontinuity() called while replaying events");
        }
        try {
            if (this.currentMutableFile != null) {
                this.closeFile();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.fileManager.registerDiscontinuity(newOriginRound);
        }
        return false;
    }

    public void updateNonAncientEventBoundary(@NonNull EventWindow nonAncientBoundary) {
        if (nonAncientBoundary.ancientThreshold() < this.nonAncientBoundary) {
            throw new IllegalArgumentException("Non-ancient boundary cannot be decreased. Current = " + this.nonAncientBoundary + ", requested = " + String.valueOf(nonAncientBoundary));
        }
        this.nonAncientBoundary = nonAncientBoundary.ancientThreshold();
    }

    public void setMinimumAncientIdentifierToStore(@NonNull Long minimumAncientIdentifierToStore) {
        this.minimumAncientIdentifierToStore = minimumAncientIdentifierToStore;
        this.pruneOldFiles();
    }

    private void closeFile() {
        try {
            this.previousSpan = this.currentMutableFile.getUtilizedSpan();
            if (!this.bootstrapMode) {
                this.averageSpanUtilization.add(this.previousSpan);
            }
            this.currentMutableFile.close();
            this.fileManager.finishedWritingFile(this.currentMutableFile);
            this.currentMutableFile = null;
            this.pruneOldFiles();
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to prune files", e);
        }
    }

    private void pruneOldFiles() {
        if (!this.streamingNewEvents) {
            return;
        }
        try {
            this.fileManager.pruneOldFiles(this.minimumAncientIdentifierToStore);
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to prune old files", e);
        }
    }

    public boolean prepareOutputStream(@NonNull PlatformEvent eventToWrite) throws IOException {
        boolean fileClosed = false;
        if (this.currentMutableFile != null) {
            boolean fileIsFull;
            boolean fileCanContainEvent = this.currentMutableFile.canContain(eventToWrite.getBirthRound());
            boolean bl = fileIsFull = DataUnit.UNIT_BYTES.convertTo(this.currentMutableFile.fileSize(), DataUnit.UNIT_MEGABYTES) >= (double)this.preferredFileSizeMegabytes;
            if (!fileCanContainEvent || fileIsFull) {
                this.closeFile();
                fileClosed = true;
            }
            if (fileIsFull) {
                this.bootstrapMode = false;
            }
        }
        if (this.currentMutableFile == null) {
            long upperBound = this.nonAncientBoundary + this.computeNewFileSpan(this.nonAncientBoundary, eventToWrite.getBirthRound());
            this.currentMutableFile = this.fileManager.getNextFileDescriptor(this.nonAncientBoundary, upperBound).getMutableFile(this.pcesFileWriterType);
        }
        return fileClosed;
    }

    private long computeNewFileSpan(long minimumLowerBound, long nextAncientIdentifierToWrite) {
        long basisSpan = this.bootstrapMode || this.averageSpanUtilization.isEmpty() ? this.previousSpan : this.averageSpanUtilization.getAverage();
        double overlapFactor = this.bootstrapMode ? this.bootstrapSpanOverlapFactor : this.spanOverlapFactor;
        long desiredSpan = (long)((double)basisSpan * overlapFactor);
        long minimumSpan = nextAncientIdentifierToWrite + (long)this.minimumSpan - minimumLowerBound;
        return Math.max(desiredSpan, minimumSpan);
    }

    public boolean isStreamingNewEvents() {
        return this.streamingNewEvents;
    }

    public long getNonAncientBoundary() {
        return this.nonAncientBoundary;
    }

    public PcesMutableFile getCurrentMutableFile() {
        return this.currentMutableFile;
    }

    public void closeCurrentMutableFile() {
        if (this.currentMutableFile != null) {
            try {
                this.currentMutableFile.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

