/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.records;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.util.HapiUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public interface RecordCache {
    public static final Set<ResponseCodeEnum> NODE_FAILURES = EnumSet.of(ResponseCodeEnum.INVALID_NODE_ACCOUNT, ResponseCodeEnum.INVALID_PAYER_SIGNATURE);
    public static final Comparator<TransactionRecord> RECORD_COMPARATOR = Comparator.comparing(rec -> rec.receiptOrThrow().status(), (a, b) -> NODE_FAILURES.contains(a) == NODE_FAILURES.contains(b) ? 0 : (NODE_FAILURES.contains(b) ? -1 : 1)).thenComparing(rec -> rec.consensusTimestampOrElse(Timestamp.DEFAULT), HapiUtils.TIMESTAMP_COMPARATOR);

    public static boolean matchesExceptNonce(@NonNull TransactionID aTxnId, @NonNull TransactionID bTxnId) {
        Objects.requireNonNull(aTxnId);
        Objects.requireNonNull(bTxnId);
        return aTxnId.accountIDOrElse(AccountID.DEFAULT).equals((Object)bTxnId.accountIDOrElse(AccountID.DEFAULT)) && aTxnId.transactionValidStartOrElse(Timestamp.DEFAULT).equals((Object)bTxnId.transactionValidStartOrElse(Timestamp.DEFAULT)) && aTxnId.scheduled() == bTxnId.scheduled();
    }

    public static boolean isChild(@NonNull TransactionID aTxnId, @NonNull TransactionID bTxnId) {
        Objects.requireNonNull(aTxnId);
        Objects.requireNonNull(bTxnId);
        return aTxnId.nonce() == 0 && bTxnId.nonce() != 0 && RecordCache.matchesExceptNonce(aTxnId, bTxnId);
    }

    @Nullable
    public History getHistory(@NonNull TransactionID var1);

    @Nullable
    public ReceiptSource getReceipts(@NonNull TransactionID var1);

    @NonNull
    public List<TransactionRecord> getRecords(@NonNull AccountID var1);

    public record History(@NonNull Set<Long> nodeIds, @NonNull List<TransactionRecord> records, @NonNull List<TransactionRecord> childRecords) {
        public History() {
            this(new HashSet<Long>(), new ArrayList<TransactionRecord>(), new ArrayList<TransactionRecord>());
        }

        @Nullable
        public TransactionRecord userTransactionRecord() {
            return this.records.isEmpty() ? null : this.sortedRecords().getFirst();
        }

        @NonNull
        public TransactionReceipt priorityReceipt() {
            return this.records.isEmpty() ? ReceiptSource.PENDING_RECEIPT : this.sortedRecords().getFirst().receiptOrThrow();
        }

        @NonNull
        public List<TransactionRecord> duplicateRecords() {
            return this.records.isEmpty() ? Collections.emptyList() : this.sortedRecords().subList(1, this.records.size());
        }

        public int duplicateCount() {
            return this.records.isEmpty() ? 0 : this.records.size() - 1;
        }

        public List<TransactionRecord> orderedRecords() {
            ArrayList<TransactionRecord> ordered = new ArrayList<TransactionRecord>(this.records);
            ordered.addAll(this.childRecords);
            ordered.sort(RECORD_COMPARATOR);
            return ordered;
        }

        private List<TransactionRecord> sortedRecords() {
            return this.records.stream().sorted(RECORD_COMPARATOR).toList();
        }
    }

    public static interface ReceiptSource {
        public static final TransactionReceipt PENDING_RECEIPT = TransactionReceipt.newBuilder().status(ResponseCodeEnum.UNKNOWN).build();

        @NonNull
        public TransactionReceipt priorityReceipt(@NonNull TransactionID var1);

        @Nullable
        public TransactionReceipt childReceipt(@NonNull TransactionID var1);

        @NonNull
        public List<TransactionReceipt> duplicateReceipts(@NonNull TransactionID var1);

        @NonNull
        public List<TransactionReceipt> childReceipts(@NonNull TransactionID var1);
    }
}

