/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PbjMap<K, V>
implements Map<K, V> {
    public static final PbjMap EMPTY = new PbjMap(Collections.EMPTY_MAP);
    private final Map<K, V> map;
    private final List<K> sortedKeys;

    private PbjMap(Map<K, V> map) {
        this.map = Collections.unmodifiableMap(map);
        this.sortedKeys = Collections.unmodifiableList(map.keySet().stream().sorted().toList());
    }

    public static <K, V> PbjMap<K, V> of(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        if (map instanceof PbjMap) {
            return (PbjMap)map;
        }
        return new PbjMap<K, V>(map);
    }

    public List<K> getSortedKeys() {
        return this.sortedKeys;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("The map is immutable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("The map is immutable");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("The map is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("The map is immutable");
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PbjMap pbjMap = (PbjMap)o;
        return Objects.equals(this.map, pbjMap.map) && Objects.equals(this.sortedKeys, pbjMap.sortedKeys);
    }

    @Override
    public int hashCode() {
        return 31 * this.map.hashCode() + this.sortedKeys.hashCode();
    }

    public String toString() {
        return this.map.toString() + " with sortedKeys: " + String.valueOf(this.getSortedKeys());
    }
}

