/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.ConfigData;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;

@ConfigData(value="paths")
public record PathsConfig(String settingsUsedDir, String keysDirPath, String appsDirPath, String logPath, String markerFilesDir, boolean writePlatformMarkerFiles) {
    public Path getSettingsUsedDir() {
        return FileUtils.getAbsolutePath((String)this.settingsUsedDir);
    }

    public Path getKeysDirPath() {
        return FileUtils.getAbsolutePath((String)this.keysDirPath);
    }

    public Path getAppsDirPath() {
        return FileUtils.getAbsolutePath((String)this.appsDirPath);
    }

    public Path getLogPath() {
        return (Path)FileUtils.rethrowIO(() -> FileUtils.getAbsolutePath((String)this.logPath));
    }

    @Nullable
    public Path getMarkerFilesDir() {
        if (!this.writePlatformMarkerFiles || this.markerFilesDir.isEmpty() || this.markerFilesDir.equals("/dev/null")) {
            return null;
        }
        return FileUtils.getAbsolutePath((String)this.markerFilesDir);
    }
}

