/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.hashgraph.EventWindow;

public final class EventWindowUtils {
    private EventWindowUtils() {
    }

    @NonNull
    public static EventWindow createEventWindow(@NonNull ConsensusSnapshot snapshot, @NonNull Configuration configuration) {
        return EventWindowUtils.createEventWindow(snapshot, ((ConsensusConfig)configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient());
    }

    @NonNull
    public static EventWindow createEventWindow(@NonNull ConsensusSnapshot snapshot, int roundsNonAncient) {
        long ancientThreshold = RoundCalculationUtils.getAncientThreshold(roundsNonAncient, snapshot);
        return new EventWindow(snapshot.round(), snapshot.round() + 1L, ancientThreshold, ancientThreshold);
    }
}

