/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.service.contract.impl.exec.metrics.CountAccumulateAverageMetricTriplet;
import com.hedera.node.app.service.contract.impl.exec.metrics.OpsDurationMetrics;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.common.metrics.platform.prometheus.NameConverter;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ContractMetrics {
    private static final Logger log = LogManager.getLogger(ContractMetrics.class);
    private final Metrics metrics;
    private final Supplier<ContractsConfig> contractsConfigSupplier;
    private boolean p1MetricsEnabled;
    private boolean p2MetricsEnabled;
    private final SystemContractMethodRegistry systemContractMethodRegistry;
    private CountAccumulateAverageMetricTriplet transactionDuration;
    private CountAccumulateAverageMetricTriplet successfulTransactionDuration;
    private CountAccumulateAverageMetricTriplet failedTransactionDuration;
    private CountAccumulateAverageMetricTriplet transactionGasUsed;
    private LongGauge gasPrice;
    private final OpsDurationMetrics opsDurationMetrics;
    private final HashMap<HederaFunctionality, Counter> rejectedTxsCounters = new HashMap();
    private final HashMap<HederaFunctionality, Counter> rejectedTxsLackingIntrinsicGas = new HashMap();
    private Counter rejectedEthType3Counter;
    private final Map<SystemContractMethod.SystemContract, Counter[]> systemContractMethodCounters = new HashMap<SystemContractMethod.SystemContract, Counter[]>();
    private final Map<SystemContractMethod.CallVia, Counter[]> systemContractMethodCountersVia = new HashMap<SystemContractMethod.CallVia, Counter[]>();
    private final Map<SystemContractMethod, EnumSet<SystemContractMethod.Category>> systemContractMethodErcMembers = new HashMap<SystemContractMethod, EnumSet<SystemContractMethod.Category>>();
    private final Map<SystemContractMethod.Category, Counter[]> systemContractERCTypeCounters = new HashMap<SystemContractMethod.Category, Counter[]>();
    private final Map<SystemContractMethod, EnumSet<SystemContractMethod.Category>> systemContractMethodGroupMembers = new HashMap<SystemContractMethod, EnumSet<SystemContractMethod.Category>>();
    private final Map<SystemContractMethod.Category, Counter[]> systemContractMethodGroupCounters = new HashMap<SystemContractMethod.Category, Counter[]>();
    private static final Map<HederaFunctionality, String> POSSIBLE_FAILING_TX_TYPES = Map.of(HederaFunctionality.CONTRACT_CALL, "contractCallTx", HederaFunctionality.CONTRACT_CREATE, "contractCreateTx", HederaFunctionality.ETHEREUM_TRANSACTION, "ethereumTx");
    static final String METRIC_CATEGORY = "app";
    static final String METRIC_SERVICE = "SmartContractService";
    private static final String METRIC_TXN_UNIT = "txs";
    private static final String REJECTED_NAME_TEMPLATE = "%2$s:Rejected_%1$s_total";
    private static final String REJECTED_DESCR_TEMPLATE = "submitted %1$s %3$s rejected by pureChecks";
    private static final String REJECTED_TXN_SHORT_DESCR = "txns";
    private static final String REJECTED_TYPE3_SHORT_DESCR = "Ethereum Type 3 txns";
    private static final String REJECTED_FOR_GAS_SHORT_DESCR = "txns with not even intrinsic gas";
    private static final String REJECTED_TYPE3_FUNCTIONALITY = "ethType3BlobTransaction";
    private static final EnumSet<SystemContractMethod.Category> ERC_TYPES = EnumSet.of(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.ERC721);
    private static final EnumSet<SystemContractMethod.Category> METHOD_GROUPS = EnumSet.complementOf(ERC_TYPES);
    private static final String METHOD_METRIC_NAME_TEMPLATE = "%2$s:SystemContractMethodCall_%1$s_%3$s";
    private static final String METHOD_METRIC_DESCR_TEMPLATE = "system contract method %1$s %3$s %4$s";
    private final ConcurrentHashMap<SystemContractMethod, SystemContractMethod> methodsThatHaveCallsWithNullMethod = new ConcurrentHashMap(50);

    @Inject
    public ContractMetrics(@NonNull Metrics metrics, @NonNull Supplier<ContractsConfig> contractsConfigSupplier, @NonNull SystemContractMethodRegistry systemContractMethodRegistry) {
        this.metrics = Objects.requireNonNull(metrics, "metrics (from platform via ServicesMain/Hedera must not be null");
        this.contractsConfigSupplier = Objects.requireNonNull(contractsConfigSupplier, "contracts configuration supplier must not be null");
        this.systemContractMethodRegistry = Objects.requireNonNull(systemContractMethodRegistry, "systemContractMethodRegistry must not be null");
        this.opsDurationMetrics = new OpsDurationMetrics(metrics);
    }

    public void createContractPrimaryMetrics() {
        ContractsConfig contractsConfig = Objects.requireNonNull(this.contractsConfigSupplier.get());
        this.p1MetricsEnabled = contractsConfig.metricsSmartContractPrimaryEnabled();
        if (this.p1MetricsEnabled) {
            Counter metric;
            for (HederaFunctionality txKind : POSSIBLE_FAILING_TX_TYPES.keySet()) {
                String name = ContractMetrics.toRejectedName(txKind, REJECTED_TXN_SHORT_DESCR);
                String descr = ContractMetrics.toRejectedDescr(txKind, REJECTED_TXN_SHORT_DESCR);
                Counter.Config config = new Counter.Config(METRIC_CATEGORY, name).withDescription(descr).withUnit(METRIC_TXN_UNIT);
                Counter metric2 = this.newCounter(this.metrics, config);
                this.rejectedTxsCounters.put(txKind, metric2);
            }
            for (HederaFunctionality txKind : POSSIBLE_FAILING_TX_TYPES.keySet()) {
                String functionalityName = POSSIBLE_FAILING_TX_TYPES.get(txKind) + "DueToIntrinsicGas";
                String name = ContractMetrics.toRejectedName(functionalityName, REJECTED_FOR_GAS_SHORT_DESCR);
                String descr = ContractMetrics.toRejectedDescr(functionalityName, REJECTED_FOR_GAS_SHORT_DESCR);
                Counter.Config config = new Counter.Config(METRIC_CATEGORY, name).withDescription(descr).withUnit(METRIC_TXN_UNIT);
                Counter metric3 = this.newCounter(this.metrics, config);
                this.rejectedTxsLackingIntrinsicGas.put(txKind, metric3);
            }
            String name = ContractMetrics.toRejectedName(REJECTED_TYPE3_FUNCTIONALITY, REJECTED_TYPE3_SHORT_DESCR);
            String descr = ContractMetrics.toRejectedDescr(REJECTED_TYPE3_FUNCTIONALITY, REJECTED_TYPE3_SHORT_DESCR);
            Counter.Config config = new Counter.Config(METRIC_CATEGORY, name).withDescription(descr).withUnit(METRIC_TXN_UNIT);
            this.rejectedEthType3Counter = metric = this.newCounter(this.metrics, config);
            this.transactionDuration = CountAccumulateAverageMetricTriplet.create(this.metrics, METRIC_CATEGORY, "SmartContractService:TransactionDuration", "Actual duration of processed smart contract transactions in nanoseconds");
            this.successfulTransactionDuration = CountAccumulateAverageMetricTriplet.create(this.metrics, METRIC_CATEGORY, "SmartContractService:SuccessfulTransactionDuration", "Actual duration of successful smart contract transactions in nanoseconds");
            this.failedTransactionDuration = CountAccumulateAverageMetricTriplet.create(this.metrics, METRIC_CATEGORY, "SmartContractService:FailedTransactionDuration", "Actual duration of failed smart contract transactions in nanoseconds");
            this.transactionGasUsed = CountAccumulateAverageMetricTriplet.create(this.metrics, METRIC_CATEGORY, "SmartContractService:TransactionGasUsed", "Actual gas used by smart contract transactions");
            this.gasPrice = (LongGauge)this.metrics.getOrCreate((MetricConfig)new LongGauge.Config(METRIC_CATEGORY, "SmartContractService:LatestGasPrice").withDescription("Gas price of the latest processed smart contract transaction"));
        }
    }

    @NonNull
    private Counter makeCounter(@NonNull MethodMetricType metricType, @NonNull String name, @NonNull String clarification) {
        String metricName = ContractMetrics.toMethodMetricName(name, metricType);
        String descr = ContractMetrics.toMethodMetricDescr(name, metricType, clarification);
        Counter.Config config = new Counter.Config(METRIC_CATEGORY, metricName).withDescription(descr).withUnit(METRIC_TXN_UNIT);
        return this.newCounter(this.metrics, config);
    }

    @NonNull
    private Counter[] makeCounterPair(@NonNull String name, @NonNull String clarification) {
        Counter[] metricPair = new Counter[2];
        metricPair[MethodMetricType.TOTAL.index] = this.makeCounter(MethodMetricType.TOTAL, name, clarification);
        metricPair[MethodMetricType.FAILED.index] = this.makeCounter(MethodMetricType.FAILED, name, clarification);
        return metricPair;
    }

    public void createContractSecondaryMetrics() {
        if (this.systemContractMethodRegistry.size() == 0L) {
            log.warn("no system contract methods registered when trying to create secondary metrics");
        }
        ContractsConfig contractsConfig = Objects.requireNonNull(this.contractsConfigSupplier.get());
        this.p2MetricsEnabled = contractsConfig.metricsSmartContractSecondaryEnabled();
        if (this.p2MetricsEnabled) {
            Set allSystemContracts = this.systemContractMethodRegistry.allMethods().stream().map(m -> m.systemContract().orElseThrow()).collect(Collectors.toSet());
            for (SystemContractMethod.SystemContract systemContract : allSystemContracts) {
                this.systemContractMethodCounters.put(systemContract, this.makeCounterPair(systemContract.name(), ""));
            }
            for (SystemContractMethod.CallVia callVia : SystemContractMethod.CallVia.values()) {
                this.systemContractMethodCountersVia.put(callVia, this.makeCounterPair(callVia.name(), ""));
            }
            for (SystemContractMethod method : this.systemContractMethodRegistry.allMethods()) {
                EnumSet<SystemContractMethod.Category> ercMembership = this.intersect(method.categories(), ERC_TYPES);
                this.systemContractMethodErcMembers.put(method, ercMembership);
            }
            for (SystemContractMethod.Category ercType : ERC_TYPES) {
                this.systemContractERCTypeCounters.put(ercType, this.makeCounterPair(ercType.name(), ercType.clarification()));
            }
            for (SystemContractMethod method : this.systemContractMethodRegistry.allMethods()) {
                EnumSet<SystemContractMethod.Category> groupMembership = this.intersect(method.categories(), METHOD_GROUPS);
                this.systemContractMethodGroupMembers.put(method, groupMembership);
            }
            for (SystemContractMethod.Category methodGroup : METHOD_GROUPS) {
                this.systemContractMethodGroupCounters.put(methodGroup, this.makeCounterPair(methodGroup.name(), methodGroup.clarification()));
            }
        }
    }

    public void incrementRejectedTx(@NonNull HederaFunctionality txKind) {
        this.bumpRejectedTx(txKind, 1L);
    }

    public void bumpRejectedTx(@NonNull HederaFunctionality txKind, long bumpBy) {
        if (this.p1MetricsEnabled) {
            Objects.requireNonNull(this.rejectedTxsCounters.get(txKind)).add(bumpBy);
        }
    }

    public void incrementRejectedForGasTx(@NonNull HederaFunctionality txKind) {
        this.bumpRejectedForGasTx(txKind, 1L);
    }

    public void bumpRejectedForGasTx(@NonNull HederaFunctionality txKind, long bumpBy) {
        if (this.p1MetricsEnabled) {
            Objects.requireNonNull(this.rejectedTxsLackingIntrinsicGas.get(txKind)).add(bumpBy);
        }
    }

    public void incrementRejectedType3EthTx() {
        this.bumpRejectedType3EthTx(1L);
    }

    public void bumpRejectedType3EthTx(long bumpBy) {
        if (this.p1MetricsEnabled) {
            this.rejectedEthType3Counter.add(bumpBy);
        }
    }

    public void incrementSystemMethodCall(@NonNull SystemContractMethod systemContractMethod, @NonNull MessageFrame.State state) {
        systemContractMethod = this.systemContractMethodRegistry.fromMissingContractGetWithContract(Objects.requireNonNull(systemContractMethod));
        Objects.requireNonNull(state);
        MethodResult result = MethodResult.from(state);
        if (this.p2MetricsEnabled) {
            try {
                Consumer<Counter[]> bumpMetricsPair = metricsPair -> {
                    metricsPair[MethodMetricType.TOTAL.index].increment();
                    if (MethodResult.FAILURE == result) {
                        metricsPair[MethodMetricType.FAILED.index].increment();
                    }
                };
                bumpMetricsPair.accept(this.systemContractMethodCounters.get(systemContractMethod.systemContract().orElse(null)));
                bumpMetricsPair.accept(this.systemContractMethodCountersVia.get(systemContractMethod.via()));
                this.systemContractMethodErcMembers.get(systemContractMethod).forEach(ercType -> bumpMetricsPair.accept(this.systemContractERCTypeCounters.get(ercType)));
                this.systemContractMethodGroupMembers.get(systemContractMethod).forEach(group -> bumpMetricsPair.accept(this.systemContractMethodGroupCounters.get(group)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void logWarnMissingSystemContractMethodOnCall(@NonNull SystemContractMethod systemContractMethod) {
        Objects.requireNonNull(systemContractMethod);
        if (this.methodsThatHaveCallsWithNullMethod.containsKey(systemContractMethod)) {
            log.warn("Found `Call` without `SystemContractMethod`,  %s".formatted(systemContractMethod.fullyDecoratedMethodName()));
        } else {
            this.methodsThatHaveCallsWithNullMethod.put(systemContractMethod, systemContractMethod);
        }
    }

    public void recordProcessedTransaction(TransactionProcessingSummary summary) {
        if (this.p1MetricsEnabled) {
            this.transactionDuration.recordObservation(summary.durationNanos());
            if (summary.success()) {
                this.successfulTransactionDuration.recordObservation(summary.durationNanos());
            } else {
                this.failedTransactionDuration.recordObservation(summary.durationNanos());
            }
            this.transactionGasUsed.recordObservation(summary.gasUsed());
            summary.gasPrice().ifPresent(newGasPrice -> this.gasPrice.set(newGasPrice));
        }
        this.opsDurationMetrics.recordTxnTotalOpsDuration(summary.opsDurationUnitsConsumed());
    }

    public OpsDurationMetrics opsDurationMetrics() {
        return this.opsDurationMetrics;
    }

    @VisibleForTesting
    @NonNull
    public Set<Counter> getAllP1Counters() {
        HashSet<Counter> allCounters = new HashSet<Counter>(200);
        allCounters.addAll(this.rejectedTxsCounters.values());
        allCounters.addAll(this.rejectedTxsLackingIntrinsicGas.values());
        if (this.rejectedEthType3Counter != null) {
            allCounters.add(this.rejectedEthType3Counter);
        }
        return allCounters;
    }

    @VisibleForTesting
    @NonNull
    public Set<Counter> getAllP2Counters() {
        HashSet<Counter> allCounters = new HashSet<Counter>(200);
        Consumer<Map> adder = map -> map.values().forEach(counterPair -> {
            allCounters.add(counterPair[MethodMetricType.TOTAL.index]);
            allCounters.add(counterPair[MethodMetricType.FAILED.index]);
        });
        adder.accept(this.systemContractMethodCounters);
        adder.accept(this.systemContractMethodCountersVia);
        adder.accept(this.systemContractERCTypeCounters);
        adder.accept(this.systemContractMethodGroupCounters);
        return allCounters;
    }

    @VisibleForTesting
    @NonNull
    public Set<Counter> getAllCounters() {
        Set<Counter> allCounters = this.getAllP1Counters();
        allCounters.addAll(this.getAllP2Counters());
        return allCounters;
    }

    @VisibleForTesting
    @NonNull
    public Map<String, Long> getAllP1CounterValues() {
        return this.getAllP1Counters().stream().collect(Collectors.toMap(Metric::getName, Counter::get));
    }

    @VisibleForTesting
    @NonNull
    public Map<String, Long> getAllCounterValues() {
        return this.getAllCounters().stream().collect(Collectors.toMap(Metric::getName, Counter::get));
    }

    @VisibleForTesting
    @NonNull
    public List<String> getAllP1CounterNames() {
        return this.getAllP1Counters().stream().map(Metric::getName).sorted().toList();
    }

    @VisibleForTesting
    @NonNull
    public List<String> getAllCounterNames() {
        long n = this.getAllCounters().stream().map(Metric::getDescription).count();
        return this.getAllCounters().stream().map(Metric::getName).sorted().toList();
    }

    @VisibleForTesting
    @NonNull
    public List<String> getAllCounterDescriptions() {
        return this.getAllCounters().stream().map(Metric::getDescription).sorted().toList();
    }

    @VisibleForTesting
    @NonNull
    public String allCountersToString() {
        return "{" + this.allCountersAsTable().replace("\n", ", ") + "}";
    }

    @VisibleForTesting
    @NonNull
    public String allCountersAsTable() {
        return this.getAllCounterValues().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + ": " + String.valueOf(e.getValue())).collect(Collectors.joining("\n"));
    }

    @VisibleForTesting
    public long getProcessedTransactionCount() {
        return this.transactionDuration.counter().get();
    }

    @NonNull
    private Counter newCounter(@NonNull Metrics metrics, @NonNull Counter.Config config) {
        return (Counter)metrics.getOrCreate((MetricConfig)config);
    }

    @NonNull
    private static String toRejectedName(@NonNull HederaFunctionality functionality, @NonNull String shortDescription) {
        return ContractMetrics.toRejectedName(POSSIBLE_FAILING_TX_TYPES.get(functionality), shortDescription);
    }

    @NonNull
    private static String toRejectedName(@NonNull String functionality, @NonNull String shortDescription) {
        return ContractMetrics.toString(REJECTED_NAME_TEMPLATE, functionality, shortDescription);
    }

    @NonNull
    private static String toRejectedDescr(@NonNull HederaFunctionality functionality, @NonNull String shortDescription) {
        return ContractMetrics.toString(REJECTED_DESCR_TEMPLATE, POSSIBLE_FAILING_TX_TYPES.get(functionality), shortDescription);
    }

    @NonNull
    private static String toRejectedDescr(@NonNull String functionality, @NonNull String shortDescription) {
        return ContractMetrics.toString(REJECTED_DESCR_TEMPLATE, functionality, shortDescription);
    }

    @NonNull
    private static String toMethodMetricName(@NonNull String name, @NonNull MethodMetricType type) {
        return ContractMetrics.toString(METHOD_METRIC_NAME_TEMPLATE, name, type, "");
    }

    @NonNull
    private static String toMethodMetricDescr(@NonNull String name, @NonNull MethodMetricType type, @NonNull String clarification) {
        return ContractMetrics.toString(METHOD_METRIC_DESCR_TEMPLATE, name, type, clarification);
    }

    @NonNull
    private static String toString(@NonNull String template, @NonNull String functionality, @NonNull String shortDescription) {
        String possiblyUnacceptableName = template.formatted(functionality, METRIC_SERVICE, shortDescription);
        String definitelyAcceptableName = NameConverter.fix((String)possiblyUnacceptableName);
        return definitelyAcceptableName;
    }

    @NonNull
    private static String toString(@NonNull String template, @NonNull String name, @NonNull MethodMetricType type, @NonNull String clarification) {
        String possiblyUnacceptableName = template.formatted(new Object[]{name, METRIC_SERVICE, type, clarification});
        String definitelyAcceptableName = NameConverter.fix((String)possiblyUnacceptableName);
        return definitelyAcceptableName;
    }

    @NonNull
    private <E extends Enum<E>> EnumSet<E> intersect(@NonNull EnumSet<E> set1, @NonNull EnumSet<E> set2) {
        Object r = set1.clone();
        ((AbstractCollection)r).retainAll(set2);
        return r;
    }

    private static enum MethodMetricType {
        TOTAL(0, "total"),
        FAILED(1, "failed");

        public final int index;
        public final String name;

        private MethodMetricType(int index, String name) {
            this.index = index;
            this.name = name;
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }

    static enum MethodResult {
        SUCCESS,
        FAILURE;


        @NonNull
        public static MethodResult from(@NonNull MessageFrame.State state) {
            return switch (state) {
                case MessageFrame.State.CODE_SUCCESS, MessageFrame.State.COMPLETED_SUCCESS -> SUCCESS;
                default -> FAILURE;
            };
        }
    }

    public record TransactionProcessingSummary(long durationNanos, long opsDurationUnitsConsumed, long gasUsed, OptionalLong gasPrice, boolean success) {
    }
}

