/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.ScheduleEvmAccount;
import com.hedera.node.app.service.contract.impl.state.TokenEvmAccount;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomSelfDestructOperation
extends AbstractOperation {
    private static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final UseEIP6780Semantics eip6780Semantics;
    private final AddressChecks addressChecks;

    public CustomSelfDestructOperation(@NonNull GasCalculator gasCalculator, @NonNull AddressChecks addressChecks, UseEIP6780Semantics eip6780Semantics) {
        super(CustomizedOpcodes.SELFDESTRUCT.opcode(), "SELFDESTRUCT", 1, 0, gasCalculator);
        this.eip6780Semantics = eip6780Semantics;
        this.addressChecks = addressChecks;
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        try {
            Address beneficiaryAddress = Words.toAddress((Bytes)frame.popStackItem());
            Address tbdAddress = frame.getRecipientAddress();
            ProxyWorldUpdater proxyWorldUpdater = (ProxyWorldUpdater)frame.getWorldUpdater();
            boolean contractCreatedInThisTransaction = frame.wasCreatedInTransaction(tbdAddress);
            boolean contractIsItsOwnBeneficiary = tbdAddress.equals((Object)beneficiaryAddress);
            boolean contractIsToBeDeleted = switch (this.eip6780Semantics.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> contractCreatedInThisTransaction;
            };
            Wei inheritance = Objects.requireNonNull(proxyWorldUpdater.get(tbdAddress)).getBalance();
            Account beneficiary = proxyWorldUpdater.get(beneficiaryAddress);
            boolean beneficiaryIsWarm = frame.warmUpAddress(beneficiaryAddress) || this.gasCalculator().isPrecompile(beneficiaryAddress);
            long coldAccountAccessCost = beneficiaryIsWarm ? 0L : this.gasCalculator().getColdAccountAccessCost();
            long costWithoutBeneficiary = this.getSelfDestructGas(null, Wei.ZERO);
            long costWithBeneficiary = this.getSelfDestructGas(beneficiary, inheritance) + coldAccountAccessCost;
            if (frame.isStatic()) {
                return this.resultFor(costWithBeneficiary, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
            }
            if (frame.getRemainingGas() < costWithBeneficiary) {
                return this.resultFor(costWithBeneficiary, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Optional<ExceptionalHaltReason> maybeReasonToHalt = this.validateHederaRestrictionsOnBeneficiary(tbdAddress, beneficiaryAddress, frame).or(() -> this.validateHederaRestrictionsOnContract(tbdAddress, beneficiaryAddress, frame, contractIsToBeDeleted)).or(() -> proxyWorldUpdater.tryTrackingSelfDestructBeneficiary(tbdAddress, beneficiaryAddress, frame)).or(() -> proxyWorldUpdater.tryTransfer(tbdAddress, beneficiaryAddress, inheritance.toLong(), FrameUtils.isDelegateCall(frame)));
            if (maybeReasonToHalt.isPresent()) {
                return this.resultFor(costWithoutBeneficiary, maybeReasonToHalt.get());
            }
            if (contractIsToBeDeleted) {
                frame.addSelfDestruct(tbdAddress);
            }
            if (!contractIsItsOwnBeneficiary || contractIsToBeDeleted) {
                proxyWorldUpdater.trackSelfDestructBeneficiary(tbdAddress, beneficiaryAddress, frame);
                frame.addRefund(beneficiaryAddress, inheritance);
            }
            frame.setState(MessageFrame.State.CODE_SUCCESS);
            return this.resultFor(costWithBeneficiary, null);
        }
        catch (UnderflowException ignore) {
            return UNDERFLOW_RESPONSE;
        }
    }

    @NonNull
    protected Optional<ExceptionalHaltReason> validateHederaRestrictionsOnBeneficiary(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame) {
        Objects.requireNonNull(deleted);
        Objects.requireNonNull(beneficiary);
        Objects.requireNonNull(frame);
        ProxyWorldUpdater proxyWorldUpdater = (ProxyWorldUpdater)frame.getWorldUpdater();
        MutableAccount beneficiaryAccount = proxyWorldUpdater.getAccount(beneficiary);
        return Stream.of(this.addressChecks.isSystemAccount(beneficiary), !this.addressChecks.isPresent(beneficiary, frame), beneficiaryAccount == null, beneficiaryAccount instanceof TokenEvmAccount, beneficiaryAccount instanceof ScheduleEvmAccount).filter(Boolean.TRUE::equals).findFirst().flatMap(op -> Optional.of(CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS));
    }

    @NonNull
    protected Optional<ExceptionalHaltReason> validateHederaRestrictionsOnContract(@NonNull Address deleted, @NonNull Address beneficiary, @NonNull MessageFrame frame, boolean contractIsToBeDeleted) {
        Objects.requireNonNull(deleted);
        Objects.requireNonNull(beneficiary);
        Objects.requireNonNull(frame);
        ProxyWorldUpdater proxyWorldUpdater = (ProxyWorldUpdater)frame.getWorldUpdater();
        AbstractProxyEvmAccount deletedAccount = (AbstractProxyEvmAccount)Objects.requireNonNull(proxyWorldUpdater.get(deleted));
        if (deletedAccount.numTreasuryTitles() > 0) {
            return Optional.of(CustomExceptionalHaltReason.CONTRACT_IS_TREASURY);
        }
        if ((contractIsToBeDeleted || !deleted.equals((Object)beneficiary)) && deletedAccount.numPositiveTokenBalances() > 0) {
            return Optional.of(CustomExceptionalHaltReason.CONTRACT_STILL_OWNS_NFTS);
        }
        return Optional.empty();
    }

    @NonNull
    private Operation.OperationResult resultFor(long cost, @Nullable ExceptionalHaltReason reason) {
        return new Operation.OperationResult(cost, reason);
    }

    private long getSelfDestructGas(@Nullable Account beneficiary, @NonNull Wei inheritance) {
        return this.gasCalculator().selfDestructOperationGasCost(beneficiary, inheritance);
    }

    public static enum UseEIP6780Semantics {
        NO,
        YES;

    }
}

