/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.mint;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.mint.MintTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MintDecoder {
    private static final TupleType MINT_RESULT_ENCODER = TupleType.parse((String)"(int64,int64,int64[])");
    public static final DispatchForResponseCodeHtsCall.OutputFn MINT_OUTPUT_FN = recordBuilder -> MINT_RESULT_ENCODER.encode((Object)Tuple.of((Object)recordBuilder.status().protoOrdinal(), (Object)recordBuilder.getNewTotalSupply(), (Object)recordBuilder.serialNumbers().stream().mapToLong(Long::longValue).toArray()));

    @Inject
    public MintDecoder() {
    }

    public TransactionBody decodeMint(@NonNull HtsCallAttempt attempt) {
        Tuple call = MintTranslator.MINT.decodeCall(attempt.inputBytes());
        long amount = ((BigInteger)call.get(1)).longValueExact();
        return TransactionBody.newBuilder().tokenMint(this.mint(attempt, (Address)call.get(0), amount, (byte[][])call.get(2))).build();
    }

    public TransactionBody decodeMintV2(@NonNull HtsCallAttempt attempt) {
        Tuple call = MintTranslator.MINT_V2.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenMint(this.mint(attempt, (Address)call.get(0), (Long)call.get(1), (byte[][])call.get(2))).build();
    }

    private TokenMintTransactionBody mint(@NonNull HtsCallAttempt attempt, @NonNull Address token, long amount, @NonNull byte[][] metadataArray) {
        ArrayList<Bytes> metadata = new ArrayList<Bytes>();
        for (byte[] data : metadataArray) {
            metadata.add(Bytes.wrap((byte[])data));
        }
        return TokenMintTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token)).amount(amount).metadata(metadata).build();
    }
}

