/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.records;

import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.ExecutedInitcode;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActions;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.types.StreamMode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public interface ContractOperationStreamBuilder
extends DeleteCapableTransactionStreamBuilder {
    public ContractOperationStreamBuilder testForIdenticalKeys(@NonNull Predicate<Object> var1);

    public ContractOperationStreamBuilder transactionFee(long var1);

    public void trackExplicitRewardSituation(@NonNull AccountID var1);

    public Set<AccountID> explicitRewardSituationIds();

    default public ContractOperationStreamBuilder withCommonFieldsSetFrom(@NonNull CallOutcome outcome, @NonNull HandleContext context) {
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(context);
        if (outcome.actions() != null) {
            this.addContractActions(new ContractActions(outcome.actions()), false);
            this.addActions(outcome.actions());
        }
        if (outcome.hasTxStorageUsage()) {
            boolean traceExplicitWrites;
            TxStorageUsage txStorageUsage = outcome.txStorageUsageOrThrow();
            List<StorageAccesses> storageAccesses = txStorageUsage.accesses();
            StreamMode streamMode = ((BlockStreamConfig)context.configuration().getConfigData(BlockStreamConfig.class)).streamMode();
            if (streamMode != StreamMode.BLOCKS && !storageAccesses.isEmpty()) {
                this.addContractStateChanges(Objects.requireNonNull(ConversionUtils.asPbjStateChanges(storageAccesses)), false);
            }
            boolean bl = traceExplicitWrites = !txStorageUsage.hasChangedKeys();
            if (streamMode != StreamMode.RECORDS) {
                this.addContractSlotUsages(Objects.requireNonNull(ConversionUtils.asPbjSlotUsages(storageAccesses, traceExplicitWrites)));
            }
            if (!traceExplicitWrites) {
                Set<SlotKey> changedKeys = txStorageUsage.changedKeysOrThrow();
                this.testForIdenticalKeys(o -> {
                    if (o instanceof SlotKey) {
                        SlotKey slotKey = (SlotKey)o;
                        return !changedKeys.contains(slotKey);
                    }
                    return false;
                });
            }
        }
        if (outcome.hasLogs()) {
            this.addLogs(outcome.logsOrThrow());
        }
        if (outcome.hasChangedNonces()) {
            this.changedNonceInfo(outcome.changedNonceInfosOrThrow());
        }
        if (outcome.hasCreatedContractIds()) {
            this.createdContractIds(outcome.createdContractIdsOrThrow());
        }
        return this;
    }

    @Deprecated
    @NonNull
    public ContractOperationStreamBuilder addContractActions(@NonNull ContractActions var1, boolean var2);

    @NonNull
    public ContractOperationStreamBuilder addActions(@NonNull List<ContractAction> var1);

    @Deprecated
    @NonNull
    public ContractOperationStreamBuilder addContractBytecode(@NonNull ContractBytecode var1, boolean var2);

    @NonNull
    public ContractOperationStreamBuilder addInitcode(@NonNull ExecutedInitcode var1);

    @Deprecated
    @NonNull
    public ContractOperationStreamBuilder addContractStateChanges(@NonNull ContractStateChanges var1, boolean var2);

    @NonNull
    public ContractOperationStreamBuilder addContractSlotUsages(@NonNull List<ContractSlotUsage> var1);

    @NonNull
    public ContractOperationStreamBuilder addLogs(@NonNull List<EvmTransactionLog> var1);

    @NonNull
    public ContractOperationStreamBuilder changedNonceInfo(@NonNull List<ContractNonceInfo> var1);

    @NonNull
    public ContractOperationStreamBuilder createdContractIds(@NonNull List<ContractID> var1);
}

