/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap;

import com.swirlds.common.FastCopyable;
import com.swirlds.fchashmap.ModifiableValue;
import com.swirlds.fchashmap.internal.FCHashMapEntrySet;
import com.swirlds.fchashmap.internal.FCHashMapFamily;
import com.swirlds.fchashmap.internal.Mutation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hiero.base.exceptions.ReferenceCountException;

@Deprecated
public class FCHashMap<K, V>
extends AbstractMap<K, V>
implements FastCopyable {
    public static final int REBUILD_SPLIT_FACTOR = 7;
    public static final int REBUILD_THREAD_COUNT = 24;
    final FCHashMapFamily<K, V> family;
    private final long version;
    private boolean immutable;
    private final AtomicInteger size;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public FCHashMap() {
        this(0);
    }

    public FCHashMap(int capacity) {
        this.family = new FCHashMapFamily(capacity);
        this.version = 0L;
        this.immutable = false;
        this.size = new AtomicInteger(0);
    }

    private FCHashMap(FCHashMap<K, V> that) {
        this.family = that.family;
        this.version = this.family.copyMap();
        this.size = new AtomicInteger(that.size.get());
        this.immutable = false;
    }

    FCHashMapFamily<K, V> getFamily() {
        return this.family;
    }

    public synchronized FCHashMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        try {
            FCHashMap<K, V> fCHashMap = new FCHashMap<K, V>(this);
            return fCHashMap;
        }
        finally {
            this.immutable = true;
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized boolean release() {
        boolean previouslyReleased = this.released.getAndSet(true);
        if (previouslyReleased) {
            throw new ReferenceCountException("this object has already been released");
        }
        this.family.releaseMap(this.version);
        return true;
    }

    public boolean isDestroyed() {
        return this.released.get();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean containsKey(Object key) {
        Mutation<V> mutation = this.family.getMutation(this.version, key);
        return mutation != null && mutation.getValue() != null;
    }

    public void initialInjection(K key, V value) {
        this.family.getData().put(key, new Mutation<V>(this.version, value, null));
    }

    public void initialResize() {
        this.size.set(this.family.getData().size());
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        Mutation<V> mutation = this.family.getMutation(this.version, key);
        return mutation == null ? null : (V)mutation.getValue();
    }

    public ModifiableValue<V> getForModify(K key) {
        this.throwIfImmutable();
        return this.family.getForModify(key);
    }

    @Override
    public V put(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.throwIfImmutable();
        return this.family.mutate(key, value, this.size);
    }

    @Override
    public V remove(@NonNull Object key) {
        Objects.requireNonNull(key, "key must not be null");
        this.throwIfImmutable();
        return this.family.mutate(key, null, this.size);
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new FCHashMapEntrySet<K, V>(this, this.family);
    }
}

