/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes;
import org.apache.tuweni.bytes.MutableBytes;

class ArrayWrappingBytes
extends AbstractBytes {
    protected final byte[] bytes;
    protected final int offset;
    protected final int length;

    ArrayWrappingBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    ArrayWrappingBytes(byte[] bytes, int offset, int length) {
        Checks.checkArgument(length >= 0, "Invalid negative length", new Object[0]);
        if (bytes.length > 0) {
            Checks.checkElementIndex(offset, bytes.length);
        }
        Checks.checkArgument(offset + length <= bytes.length, "Provided length %s is too big: the value has only %s bytes from offset %s", length, bytes.length - offset, offset);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public byte get(int i) {
        Checks.checkElementIndex(i, this.size());
        return this.bytes[this.offset + i];
    }

    @Override
    public Bytes slice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, this.length);
        Checks.checkArgument(i + length <= this.length, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, this.length, this.length - i, i);
        return length == 32 ? new ArrayWrappingBytes32(this.bytes, this.offset + i) : new ArrayWrappingBytes(this.bytes, this.offset + i, length);
    }

    @Override
    public Bytes copy() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this;
        }
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return new MutableArrayWrappingBytes(this.toArray());
    }

    @Override
    public int commonPrefixLength(Bytes other) {
        int i;
        if (!(other instanceof ArrayWrappingBytes)) {
            return super.commonPrefixLength(other);
        }
        ArrayWrappingBytes o = (ArrayWrappingBytes)other;
        for (i = 0; i < this.length && i < o.length && this.bytes[this.offset + i] == o.bytes[o.offset + i]; ++i) {
        }
        return i;
    }

    @Override
    public void update(MessageDigest digest) {
        digest.update(this.bytes, this.offset, this.length);
    }

    @Override
    public void copyTo(MutableBytes destination, int destinationOffset) {
        if (!(destination instanceof MutableArrayWrappingBytes)) {
            super.copyTo(destination, destinationOffset);
            return;
        }
        int size = this.size();
        if (size == 0) {
            return;
        }
        Checks.checkElementIndex(destinationOffset, destination.size());
        Checks.checkArgument(destination.size() - destinationOffset >= size, "Cannot copy %s bytes, destination has only %s bytes from index %s", size, destination.size() - destinationOffset, destinationOffset);
        MutableArrayWrappingBytes d = (MutableArrayWrappingBytes)destination;
        System.arraycopy(this.bytes, this.offset, d.bytes, d.offset + destinationOffset, size);
    }

    @Override
    public void appendTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes, this.offset, this.length);
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBytes(this.bytes, this.offset, this.length);
    }

    @Override
    public byte[] toArray() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    @Override
    public byte[] toArrayUnsafe() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this.bytes;
        }
        return this.toArray();
    }
}

