/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.security.MessageDigest;
import java.util.List;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableBytes;

final class ConcatenatedBytes
extends AbstractBytes {
    private final Bytes[] values;
    private final int size;

    private ConcatenatedBytes(Bytes[] values, int totalSize) {
        this.values = values;
        this.size = totalSize;
    }

    static Bytes wrap(Bytes ... values) {
        if (values.length == 0) {
            return EMPTY;
        }
        if (values.length == 1) {
            return values[0];
        }
        int count = 0;
        int totalSize = 0;
        for (Bytes value : values) {
            int size = value.size();
            try {
                totalSize = Math.addExact(totalSize, size);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
            }
            if (value instanceof ConcatenatedBytes) {
                count += ((ConcatenatedBytes)value).values.length;
                continue;
            }
            if (size == 0) continue;
            ++count;
        }
        if (count == 0) {
            return Bytes.EMPTY;
        }
        if (count == values.length) {
            return new ConcatenatedBytes(values, totalSize);
        }
        Bytes[] concatenated = new Bytes[count];
        int i = 0;
        for (Bytes value : values) {
            if (value instanceof ConcatenatedBytes) {
                Bytes[] subvalues = ((ConcatenatedBytes)value).values;
                System.arraycopy(subvalues, 0, concatenated, i, subvalues.length);
                i += subvalues.length;
                continue;
            }
            if (value.size() == 0) continue;
            concatenated[i++] = value;
        }
        return new ConcatenatedBytes(concatenated, totalSize);
    }

    static Bytes wrap(List<Bytes> values) {
        if (values.size() == 0) {
            return EMPTY;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        int count = 0;
        int totalSize = 0;
        for (Bytes value : values) {
            int size = value.size();
            try {
                totalSize = Math.addExact(totalSize, size);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Combined length of values is too long (> Integer.MAX_VALUE)");
            }
            if (value instanceof ConcatenatedBytes) {
                count += ((ConcatenatedBytes)value).values.length;
                continue;
            }
            if (size == 0) continue;
            ++count;
        }
        if (count == 0) {
            return Bytes.EMPTY;
        }
        if (count == values.size()) {
            return new ConcatenatedBytes(values.toArray(new Bytes[0]), totalSize);
        }
        Bytes[] concatenated = new Bytes[count];
        int i = 0;
        for (Bytes value : values) {
            if (value instanceof ConcatenatedBytes) {
                Bytes[] subvalues = ((ConcatenatedBytes)value).values;
                System.arraycopy(subvalues, 0, concatenated, i, subvalues.length);
                i += subvalues.length;
                continue;
            }
            if (value.size() == 0) continue;
            concatenated[i++] = value;
        }
        return new ConcatenatedBytes(concatenated, totalSize);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte get(int i) {
        Checks.checkElementIndex(i, this.size);
        for (Bytes value : this.values) {
            int vSize = value.size();
            if (i < vSize) {
                return value.get(i);
            }
            i -= vSize;
        }
        throw new IllegalStateException("element sizes do not match total size");
    }

    @Override
    public Bytes slice(int i, int length) {
        int remaining;
        int vSize;
        if (i == 0 && length == this.size) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, this.size);
        Checks.checkArgument(i + length <= this.size, "Provided length %s is too large: the value has size %s and has only %s bytes from %s", length, this.size, this.size - i, i);
        int j = 0;
        while (i >= (vSize = this.values[j].size())) {
            i -= vSize;
            ++j;
        }
        if (i + length < vSize) {
            return this.values[j].slice(i, length);
        }
        Bytes firstValue = this.values[j].slice(i);
        int firstOffset = j;
        for (remaining = length - (vSize - i); remaining > 0; remaining -= vSize) {
            if (++j >= this.values.length) {
                throw new IllegalStateException("element sizes do not match total size");
            }
            vSize = this.values[j].size();
            if (length < vSize + firstValue.size()) break;
        }
        Bytes[] combined = new Bytes[j - firstOffset + 1];
        combined[0] = firstValue;
        if (remaining > 0) {
            if (combined.length > 2) {
                System.arraycopy(this.values, firstOffset + 1, combined, 1, combined.length - 2);
            }
            combined[combined.length - 1] = this.values[j].slice(0, remaining);
        } else if (combined.length > 1) {
            System.arraycopy(this.values, firstOffset + 1, combined, 1, combined.length - 1);
        }
        return new ConcatenatedBytes(combined, length);
    }

    @Override
    public Bytes copy() {
        return this.mutableCopy();
    }

    @Override
    public MutableBytes mutableCopy() {
        if (this.size == 0) {
            return MutableBytes.EMPTY;
        }
        MutableBytes result = MutableBytes.create(this.size);
        this.copyToUnchecked(result, 0);
        return result;
    }

    @Override
    public void copyTo(MutableBytes destination, int destinationOffset) {
        if (this.size == 0) {
            return;
        }
        Checks.checkElementIndex(destinationOffset, destination.size());
        Checks.checkArgument(destination.size() - destinationOffset >= this.size, "Cannot copy %s bytes, destination has only %s bytes from index %s", this.size, destination.size() - destinationOffset, destinationOffset);
        this.copyToUnchecked(destination, destinationOffset);
    }

    @Override
    public void update(MessageDigest digest) {
        for (Bytes value : this.values) {
            value.update(digest);
        }
    }

    @Override
    public byte[] toArray() {
        if (this.size == 0) {
            return new byte[0];
        }
        MutableBytes result = MutableBytes.create(this.size);
        this.copyToUnchecked(result, 0);
        return result.toArrayUnsafe();
    }

    private void copyToUnchecked(MutableBytes destination, int destinationOffset) {
        int offset = 0;
        for (Bytes value : this.values) {
            int vSize = value.size();
            if (offset + vSize > this.size) {
                throw new IllegalStateException("element sizes do not match total size");
            }
            value.copyTo(destination, destinationOffset);
            offset += vSize;
            destinationOffset += vSize;
        }
    }

    @Override
    public int hashCode() {
        return this.computeHashcode();
    }
}

