/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.roster.codec;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RosterEntryJsonCodec
implements JsonCodec<RosterEntry> {
    @NonNull
    public RosterEntry parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_node_id = 0L;
            long temp_weight = 0L;
            Bytes temp_gossip_ca_certificate = Bytes.EMPTY;
            List temp_gossip_endpoint = Collections.emptyList();
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nodeId": {
                        temp_node_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "weight": {
                        temp_weight = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "gossipCaCertificate": {
                        temp_gossip_ca_certificate = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "gossipEndpoint": {
                        temp_gossip_endpoint = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), ServiceEndpoint.JSON, (int)(maxDepth - 1));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RosterEntry(temp_node_id, temp_weight, temp_gossip_ca_certificate, temp_gossip_endpoint);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RosterEntry data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.nodeId() != 0L) {
            fieldLines.add(JsonTools.field((String)"nodeId", (long)data.nodeId()));
        }
        if (data.weight() != 0L) {
            fieldLines.add(JsonTools.field((String)"weight", (long)data.weight()));
        }
        if (data.gossipCaCertificate() != Bytes.EMPTY && data.gossipCaCertificate() != null && data.gossipCaCertificate().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"gossipCaCertificate", (Bytes)data.gossipCaCertificate()));
        }
        if (!data.gossipEndpoint().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"gossipEndpoint", ServiceEndpoint.JSON, data.gossipEndpoint()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

