/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.esaulpaugh.headlong.abi.Address;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.hapi.utils.ByteStringUtils;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.ScheduleID;
import com.hederahashgraph.api.proto.java.SignatureMap;
import com.hederahashgraph.api.proto.java.SignedTransaction;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import org.hiero.base.crypto.DigestType;

public final class CommonUtils {
    private static String sha384HashTag = "SHA-384";

    private CommonUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static String base64encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static ByteString extractTransactionBodyByteString(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        if (transaction.hasBody()) {
            return transaction.getBody().toByteString();
        }
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom((ByteString)signedTransactionBytes).getBodyBytes();
        }
        return transaction.getBodyBytes();
    }

    public static byte[] extractTransactionBodyBytes(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return ByteStringUtils.unwrapUnsafelyIfPossible(CommonUtils.extractTransactionBodyByteString(transaction));
    }

    public static com.hederahashgraph.api.proto.java.TransactionBody extractTransactionBodyUnchecked(TransactionOrBuilder transaction) {
        try {
            return com.hederahashgraph.api.proto.java.TransactionBody.parseFrom((ByteString)CommonUtils.extractTransactionBodyByteString(transaction));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static com.hederahashgraph.api.proto.java.TransactionBody extractTransactionBody(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return com.hederahashgraph.api.proto.java.TransactionBody.parseFrom((ByteString)CommonUtils.extractTransactionBodyByteString(transaction));
    }

    public static SignatureMap extractSignatureMap(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom((ByteString)signedTransactionBytes).getSigMap();
        }
        return transaction.getSigMap();
    }

    public static MessageDigest sha384DigestOrThrow() {
        try {
            return MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        }
        catch (NoSuchAlgorithmException fatal) {
            throw new IllegalStateException(fatal);
        }
    }

    public static Bytes noThrowSha384HashOf(Bytes bytes) {
        return Bytes.wrap((byte[])CommonUtils.noThrowSha384HashOf(bytes.toByteArray()));
    }

    public static byte[] noThrowSha384HashOf(byte[] byteArray) {
        try {
            return MessageDigest.getInstance(sha384HashTag).digest(byteArray);
        }
        catch (NoSuchAlgorithmException fatal) {
            throw new IllegalStateException(fatal);
        }
    }

    public static boolean productWouldOverflow(long multiplier, long multiplicand) {
        if (multiplicand == 0L) {
            return false;
        }
        long maxMultiplier = Long.MAX_VALUE / multiplicand;
        return multiplier > maxMultiplier;
    }

    @VisibleForTesting
    static void setSha384HashTag(String sha384HashTag) {
        CommonUtils.sha384HashTag = sha384HashTag;
    }

    @NonNull
    public static HederaFunctionality functionOf(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn) throws UnknownHederaFunctionality {
        Objects.requireNonNull(txn);
        return CommonPbjConverters.fromPbj(HapiUtils.functionOf((TransactionBody)CommonPbjConverters.toPbj(txn)));
    }

    public static byte[] asEvmAddress(long num) {
        byte[] evmAddress = new byte[20];
        System.arraycopy(Longs.toByteArray((long)num), 0, evmAddress, 12, 8);
        return evmAddress;
    }

    public static Instant timestampToInstant(com.hederahashgraph.api.proto.java.Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Instant pbjTimestampToInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.seconds(), timestamp.nanos());
    }

    public static ScheduleID asScheduleId(long shard, long realm, @NonNull Address address) {
        return ScheduleID.newBuilder().setShardNum(shard).setRealmNum(realm).setScheduleNum(address.value().longValueExact()).build();
    }
}

