/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.sysfiles.domain.throttling;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleBucket;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleGroup;
import com.hederahashgraph.api.proto.java.HederaFunctionality;

public class HapiThrottleUtils {
    public static ThrottleBucket<HederaFunctionality> hapiBucketFromProto(com.hederahashgraph.api.proto.java.ThrottleBucket bucket) {
        return new ThrottleBucket<HederaFunctionality>(bucket.getBurstPeriodMs(), bucket.getName(), bucket.getThrottleGroupsList().stream().map(HapiThrottleUtils::hapiGroupFromProto).toList());
    }

    public static com.hederahashgraph.api.proto.java.ThrottleBucket hapiBucketToProto(ThrottleBucket<HederaFunctionality> bucket) {
        return com.hederahashgraph.api.proto.java.ThrottleBucket.newBuilder().setName(bucket.getName()).setBurstPeriodMs(bucket.impliedBurstPeriodMs()).addAllThrottleGroups(bucket.getThrottleGroups().stream().map(HapiThrottleUtils::hapiGroupToProto).toList()).build();
    }

    public static ThrottleGroup<HederaFunctionality> hapiGroupFromProto(com.hederahashgraph.api.proto.java.ThrottleGroup group) {
        return new ThrottleGroup<HederaFunctionality>(group.getMilliOpsPerSec(), group.getOperationsList());
    }

    public static com.hederahashgraph.api.proto.java.ThrottleGroup hapiGroupToProto(ThrottleGroup<HederaFunctionality> group) {
        return com.hederahashgraph.api.proto.java.ThrottleGroup.newBuilder().setMilliOpsPerSec(group.impliedMilliOpsPerSec()).addAllOperations(group.getOperations()).build();
    }

    public static long lcm(long lhs, long rhs) {
        if (CommonUtils.productWouldOverflow(lhs, rhs)) {
            throw new ArithmeticException();
        }
        return lhs * rhs / HapiThrottleUtils.gcd(Math.min(lhs, rhs), Math.max(lhs, rhs));
    }

    private static long gcd(long lhs, long rhs) {
        return lhs == 0L ? rhs : HapiThrottleUtils.gcd(rhs % lhs, lhs);
    }

    private HapiThrottleUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }
}

