/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.state.DeduplicationCache;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.InstantSource;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class DeduplicationCacheImpl
implements DeduplicationCache {
    private final Set<TransactionID> submittedTxns = new ConcurrentSkipListSet<TransactionID>(Comparator.comparing(txnId -> txnId.transactionValidStartOrElse(Timestamp.DEFAULT), HapiUtils.TIMESTAMP_COMPARATOR).thenComparing(txnId -> txnId.accountIDOrElse(AccountID.DEFAULT), HapiUtils.ACCOUNT_ID_COMPARATOR).thenComparing(TransactionID::scheduled).thenComparing(TransactionID::nonce));
    private final ConfigProvider configProvider;
    private final InstantSource instantSource;

    @Inject
    public DeduplicationCacheImpl(@NonNull ConfigProvider configProvider, @NonNull InstantSource instantSource) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.instantSource = Objects.requireNonNull(instantSource);
    }

    @Override
    public void add(@NonNull TransactionID transactionID) {
        long epochSeconds = this.approxEarliestValidStartSecond();
        this.removeTransactionsOlderThan(epochSeconds);
        if (transactionID.transactionValidStartOrThrow().seconds() >= epochSeconds) {
            this.submittedTxns.add(transactionID);
        }
    }

    @Override
    public boolean contains(@NonNull TransactionID transactionID) {
        long epochSeconds = this.approxEarliestValidStartSecond();
        this.removeTransactionsOlderThan(epochSeconds);
        return this.submittedTxns.contains(transactionID);
    }

    @Override
    public void clear() {
        this.submittedTxns.clear();
    }

    private long approxEarliestValidStartSecond() {
        Timestamp now = HapiUtils.asTimestamp((Instant)this.instantSource.instant());
        HederaConfig config = (HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class);
        Timestamp earliestValidState = HapiUtils.minus((Timestamp)now, (long)config.transactionMaxValidDuration());
        return earliestValidState.seconds();
    }

    private void removeTransactionsOlderThan(long earliestEpochSecond) {
        Iterator<TransactionID> itr = this.submittedTxns.iterator();
        while (itr.hasNext()) {
            TransactionID txId = itr.next();
            if (txId.transactionValidStartOrThrow().seconds() < earliestEpochSecond) {
                itr.remove();
                continue;
            }
            return;
        }
    }
}

