/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.analysis;

import com.swirlds.component.framework.model.internal.analysis.InputWireDescriptor;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InputWireChecks {
    private static final Logger logger = LogManager.getLogger(InputWireChecks.class);

    private InputWireChecks() {
    }

    public static boolean checkForUnboundInputWires(@NonNull Set<InputWireDescriptor> inputWires, @NonNull Set<InputWireDescriptor> boundInputWires) {
        if (inputWires.size() == boundInputWires.size()) {
            logger.info(LogMarker.STARTUP.getMarker(), "All input wires have been bound.");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following input wire(s) were created but not bound:\n");
        for (InputWireDescriptor inputWire : inputWires) {
            if (boundInputWires.contains(inputWire)) continue;
            sb.append("  - ").append("Input wire '").append(inputWire.name()).append("' in scheduler '").append(inputWire.taskSchedulerName()).append("'\n");
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), sb.toString());
        return true;
    }
}

