/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.handlers;

import com.hedera.hapi.node.addressbook.NodeCreateTransactionBody;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.addressbook.AddressBookHelper;
import com.hedera.node.app.service.addressbook.impl.WritableNodeStore;
import com.hedera.node.app.service.addressbook.impl.records.NodeCreateStreamBuilder;
import com.hedera.node.app.service.addressbook.impl.validators.AddressBookValidator;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NodeCreateHandler
implements TransactionHandler {
    private final AddressBookValidator addressBookValidator;

    @Inject
    public NodeCreateHandler(@NonNull AddressBookValidator addressBookValidator) {
        this.addressBookValidator = Objects.requireNonNull(addressBookValidator, "The supplied argument 'addressBookValidator' must not be null");
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        NodeCreateTransactionBody op = txn.nodeCreateOrThrow();
        this.addressBookValidator.validateAccountId(op.accountId());
        PreCheckException.validateFalsePreCheck((boolean)op.gossipEndpoint().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_GOSSIP_ENDPOINT);
        PreCheckException.validateFalsePreCheck((boolean)op.serviceEndpoint().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SERVICE_ENDPOINT);
        PreCheckException.validateFalsePreCheck((op.gossipCaCertificate().length() == 0L || op.gossipCaCertificate().equals((Object)Bytes.EMPTY) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_GOSSIP_CA_CERTIFICATE);
        AddressBookValidator.validateX509Certificate(op.gossipCaCertificate());
        Key adminKey = op.adminKey();
        this.addressBookValidator.validateAdminKey(adminKey);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        NodeCreateTransactionBody op = context.body().nodeCreateOrThrow();
        context.requireKeyOrThrow(op.adminKeyOrThrow(), ResponseCodeEnum.INVALID_ADMIN_KEY);
    }

    public void handle(@NonNull HandleContext handleContext) {
        Objects.requireNonNull(handleContext);
        NodeCreateTransactionBody op = handleContext.body().nodeCreateOrThrow();
        NodesConfig nodeConfig = (NodesConfig)handleContext.configuration().getConfigData(NodesConfig.class);
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableNodeStore nodeStore = (WritableNodeStore)storeFactory.writableStore(WritableNodeStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        AccountID accountId = op.accountIdOrElse(AccountID.DEFAULT);
        HandleException.validateFalse((nodeStore.sizeOfState() >= nodeConfig.maxNumber() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_NODES_CREATED);
        HandleException.validateTrue((boolean)accountStore.contains(accountId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
        this.addressBookValidator.validateDescription(op.description(), nodeConfig);
        this.addressBookValidator.validateGossipEndpoint(op.gossipEndpoint(), nodeConfig);
        this.addressBookValidator.validateServiceEndpoint(op.serviceEndpoint(), nodeConfig);
        if (op.hasGrpcProxyEndpoint()) {
            HandleException.validateTrue((boolean)nodeConfig.webProxyEndpointsEnabled(), (ResponseCodeEnum)ResponseCodeEnum.GRPC_WEB_PROXY_NOT_SUPPORTED);
            this.addressBookValidator.validateFqdnEndpoint(op.grpcProxyEndpoint(), nodeConfig);
        }
        handleContext.attributeValidator().validateKey(op.adminKeyOrThrow(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        Node.Builder nodeBuilder = new Node.Builder().accountId(op.accountId()).description(op.description()).gossipEndpoint(op.gossipEndpoint()).serviceEndpoint(op.serviceEndpoint()).gossipCaCertificate(op.gossipCaCertificate()).grpcCertificateHash(op.grpcCertificateHash()).declineReward(op.declineReward()).adminKey(op.adminKey());
        if (op.hasGrpcProxyEndpoint()) {
            nodeBuilder.grpcProxyEndpoint(op.grpcProxyEndpoint());
        }
        Node node = nodeBuilder.nodeId(nodeStore.sizeOfState()).build();
        nodeStore.putAndIncrementCount(node);
        NodeCreateStreamBuilder recordBuilder = (NodeCreateStreamBuilder)handleContext.savepointStack().getBaseBuilder(NodeCreateStreamBuilder.class);
        recordBuilder.nodeID(node.nodeId());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        AddressBookHelper.checkDABEnabled((FeeContext)feeContext);
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
        return calculator.calculate();
    }
}

