/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.utilities;

import java.nio.ByteBuffer;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;

public final class HashTools {
    private static final int CURRENT_SERIALIZATION_VERSION = 1;
    public static final DigestType DEFAULT_DIGEST = DigestType.SHA_384;
    public static final int HASH_SIZE_BYTES = DEFAULT_DIGEST.digestLength();

    public static int getSerializationVersion() {
        return 1;
    }

    public static ByteBuffer hashToByteBuffer(Hash hash) {
        ByteBuffer buf = ByteBuffer.allocate(HASH_SIZE_BYTES);
        hash.getBytes().writeTo(buf);
        return buf.flip();
    }

    public static void hashToByteBuffer(Hash hash, ByteBuffer buf) {
        hash.getBytes().writeTo(buf);
    }

    public static Hash byteBufferToHash(ByteBuffer buffer, int serializationVersion) {
        if (serializationVersion != 1) {
            throw new IllegalArgumentException("Current version is 1, got " + serializationVersion);
        }
        byte[] bytes = new byte[DEFAULT_DIGEST.digestLength()];
        buffer.get(bytes);
        return new Hash(bytes, DEFAULT_DIGEST);
    }

    private HashTools() {
        throw new UnsupportedOperationException("Utility Class");
    }
}

