/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferStep;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdjustHbarChangesStep
extends BaseTokenHandler
implements TransferStep {
    private final CryptoTransferTransactionBody op;
    private final AccountID topLevelPayer;

    public AdjustHbarChangesStep(@NonNull CryptoTransferTransactionBody op, @NonNull AccountID topLevelPayer) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(topLevelPayer);
        this.op = op;
        this.topLevelPayer = topLevelPayer;
    }

    @Override
    public void doIn(@NonNull TransferContext transferContext) {
        Objects.requireNonNull(transferContext);
        WritableAccountStore accountStore = (WritableAccountStore)transferContext.getHandleContext().storeFactory().writableStore(WritableAccountStore.class);
        LinkedHashMap<AccountID, Long> netHbarTransfers = new LinkedHashMap<AccountID, Long>();
        LinkedHashMap<AccountID, Long> allowanceTransfers = new LinkedHashMap<AccountID, Long>();
        for (AccountAmount aa : this.op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            netHbarTransfers.merge(aa.accountID(), aa.amount(), Long::sum);
            if (!aa.isApproval() || aa.amount() >= 0L) continue;
            allowanceTransfers.merge(aa.accountID(), aa.amount(), Long::sum);
        }
        this.modifyAggregatedTransfers(netHbarTransfers, accountStore, transferContext);
        this.modifyAggregatedAllowances(allowanceTransfers, accountStore, transferContext);
    }

    private void modifyAggregatedAllowances(@NonNull Map<AccountID, Long> allowanceTransfers, @NonNull WritableAccountStore accountStore, @NonNull TransferContext transferContext) {
        for (Map.Entry<AccountID, Long> entry : allowanceTransfers.entrySet()) {
            AccountID accountId = entry.getKey();
            Long amount = entry.getValue();
            Account ownerAccount = TokenHandlerHelper.getIfUsable(accountId, accountStore, transferContext.getHandleContext().expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
            Account.Builder accountCopy = ownerAccount.copyBuilder();
            ArrayList<AccountCryptoAllowance> cryptoAllowances = new ArrayList<AccountCryptoAllowance>(ownerAccount.cryptoAllowances());
            boolean haveSpenderAllowance = false;
            for (int i = 0; i < cryptoAllowances.size(); ++i) {
                AccountCryptoAllowance allowance = (AccountCryptoAllowance)cryptoAllowances.get(i);
                AccountCryptoAllowance.Builder allowanceCopy = allowance.copyBuilder();
                if (!this.topLevelPayer.equals((Object)allowance.spenderId())) continue;
                haveSpenderAllowance = true;
                long newAllowanceAmount = allowance.amount() + amount;
                HandleException.validateTrue((newAllowanceAmount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE);
                allowanceCopy.amount(newAllowanceAmount);
                if (newAllowanceAmount != 0L) {
                    cryptoAllowances.set(i, allowanceCopy.build());
                    break;
                }
                cryptoAllowances.remove(i);
                break;
            }
            HandleException.validateTrue((boolean)haveSpenderAllowance, (ResponseCodeEnum)ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE);
            accountCopy.cryptoAllowances(cryptoAllowances);
            accountStore.put(accountCopy.build());
        }
    }

    private void modifyAggregatedTransfers(@NonNull Map<AccountID, Long> netHbarTransfers, @NonNull WritableAccountStore accountStore, @NonNull TransferContext transferContext) {
        for (Map.Entry<AccountID, Long> entry : netHbarTransfers.entrySet()) {
            List<AssessedCustomFee> assessedCustomFees;
            AccountID accountId = entry.getKey();
            Long amount = entry.getValue();
            Account account = TokenHandlerHelper.getIfUsable(accountId, accountStore, transferContext.getHandleContext().expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
            long currentBalance = account.tinybarBalance();
            long newBalance = currentBalance + amount;
            if (newBalance < 0L && this.effectivePaymentWasMade(accountId, assessedCustomFees = transferContext.getAssessedCustomFees())) {
                throw new HandleException(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
            }
            HandleException.validateTrue((newBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_ACCOUNT_BALANCE);
            Account.Builder copy = account.copyBuilder();
            accountStore.put(copy.tinybarBalance(newBalance).build());
        }
    }

    private boolean effectivePaymentWasMade(@NonNull AccountID payer, @NonNull List<AssessedCustomFee> assessedCustomFees) {
        for (AssessedCustomFee fee : assessedCustomFees) {
            if (fee.tokenId() != null || !fee.effectivePayerAccountId().contains(payer)) continue;
            return true;
        }
        return false;
    }
}

