/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.config.data.BootstrapConfig;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public class V0490FeeSchema
extends Schema {
    public static final String MIDNIGHT_RATES_STATE_KEY = "MIDNIGHT_RATES";
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();

    public V0490FeeSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((String)MIDNIGHT_RATES_STATE_KEY, (Codec)ExchangeRateSet.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        boolean isGenesis;
        boolean bl = isGenesis = ctx.previousVersion() == null;
        if (isGenesis) {
            WritableSingletonState midnightRatesState = ctx.newStates().getSingleton(MIDNIGHT_RATES_STATE_KEY);
            BootstrapConfig bootstrapConfig = (BootstrapConfig)ctx.appConfig().getConfigData(BootstrapConfig.class);
            ExchangeRateSet exchangeRateSet = ExchangeRateSet.newBuilder().currentRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesCurrentCentEquiv()).hbarEquiv(bootstrapConfig.ratesCurrentHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesCurrentExpiry())).build()).nextRate(ExchangeRate.newBuilder().centEquiv(bootstrapConfig.ratesNextCentEquiv()).hbarEquiv(bootstrapConfig.ratesNextHbarEquiv()).expirationTime(TimestampSeconds.newBuilder().seconds(bootstrapConfig.ratesNextExpiry())).build()).build();
            midnightRatesState.put((Object)exchangeRateSet);
        }
    }
}

