/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.handlers;

import com.hedera.hapi.services.auxiliary.hints.HintsPreprocessingVoteTransactionBody;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.HintsControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HintsPreprocessingVoteHandler
implements TransactionHandler {
    @NonNull
    final HintsControllers controllers;

    @Inject
    public HintsPreprocessingVoteHandler(@NonNull HintsControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        HintsPreprocessingVoteTransactionBody op = context.body().hintsPreprocessingVoteOrThrow();
        this.controllers.getInProgressById(op.constructionId()).ifPresent(controller -> {
            WritableHintsStore hintsStore = (WritableHintsStore)context.storeFactory().writableStore(WritableHintsStore.class);
            controller.addPreprocessingVote(context.creatorInfo().nodeId(), op.voteOrThrow(), hintsStore);
        });
    }
}

