/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.FieldPoint;

public abstract class AbstractFieldPoint<U extends AbstractFieldPoint>
implements FieldPoint<U> {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    protected final FieldElement x;
    protected final FieldElement y;

    AbstractFieldPoint(FieldElement x, FieldElement y) {
        this.x = x;
        this.y = y;
    }

    protected abstract U infinity();

    protected abstract U newInstance(FieldElement var1, FieldElement var2);

    @Override
    public boolean isInfinity() {
        return this.x.isZero() && this.y.isZero();
    }

    @Override
    public U add(U other) {
        if (this.isInfinity() || ((AbstractFieldPoint)other).isInfinity()) {
            return (U)(this.isInfinity() ? other : this);
        }
        if (this.equals(other)) {
            return (U)this.doub();
        }
        if (this.x.equals(((AbstractFieldPoint)other).x)) {
            return this.infinity();
        }
        FieldElement x1 = this.x;
        FieldElement y1 = this.y;
        FieldElement x2 = ((AbstractFieldPoint)other).x;
        FieldElement y2 = ((AbstractFieldPoint)other).y;
        FieldElement m = y2.subtract(y1).divide(x2.subtract(x1));
        FieldElement mSquared = m.power(2);
        FieldElement newX = mSquared.subtract((FieldElement)x1).subtract(x2);
        FieldElement newY = m.negate().multiply((FieldElement)newX).add(m.multiply(x1)).subtract(y1);
        return this.newInstance(newX, newY);
    }

    @Override
    public U multiply(U other) {
        return null;
    }

    @Override
    public U multiply(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) == 0) {
            return this.infinity();
        }
        if (n.compareTo(BigInteger.ONE) == 0) {
            return this.newInstance(this.x, this.y);
        }
        if (n.mod(TWO).compareTo(BigInteger.ZERO) == 0) {
            return (U)((AbstractFieldPoint)this.doub()).multiply(n.divide(TWO));
        }
        return ((AbstractFieldPoint)((AbstractFieldPoint)this.doub()).multiply(n.divide(TWO))).add((U)this);
    }

    @Override
    public U doub() {
        int xSquared = this.x.power(2);
        int m = xSquared.multiply((int)3).divide(this.y.multiply(2));
        int mSquared = m.power(2);
        int newX = mSquared.subtract(this.x.multiply(2));
        FieldElement newY = m.negate().multiply((int)newX).add(m.multiply(this.x)).subtract(this.y);
        return this.newInstance((FieldElement)newX, newY);
    }

    @Override
    public U negate() {
        if (this.isInfinity()) {
            return (U)this;
        }
        return this.newInstance(this.x, (FieldElement)this.y.negate());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("x", (Object)this.x).add("y", (Object)this.y).toString();
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractFieldPoint)) {
            return false;
        }
        AbstractFieldPoint other = (AbstractFieldPoint)obj;
        return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y);
    }
}

