/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import io.helidon.metadata.hson.Hson;
import io.helidon.metadata.hson.HsonException;
import io.helidon.metadata.hson.HsonValues;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

final class HsonArray
implements Hson.Array {
    private final List<Hson.Value<?>> values;

    private HsonArray(List<? extends Hson.Value<?>> array) {
        this.values = List.copyOf(array);
    }

    static Hson.Array create() {
        return new HsonArray(List.of());
    }

    static Hson.Array create(List<? extends Hson.Value<?>> values) {
        return new HsonArray(values);
    }

    static Hson.Array createStrings(List<String> strings) {
        List values = strings.stream().map(HsonValues.StringValue::create).collect(Collectors.toList());
        return new HsonArray(values);
    }

    static Hson.Array createNumbers(List<BigDecimal> numbers) {
        return new HsonArray(numbers.stream().map(HsonValues.NumberValue::create).collect(Collectors.toUnmodifiableList()));
    }

    static Hson.Array createBooleans(List<Boolean> booleans) {
        return new HsonArray(booleans.stream().map(HsonValues.BooleanValue::create).collect(Collectors.toUnmodifiableList()));
    }

    static Hson.Array create(long ... values) {
        List<BigDecimal> collect = LongStream.of(values).mapToObj(BigDecimal::new).collect(Collectors.toUnmodifiableList());
        return Hson.Array.createNumbers(collect);
    }

    static Hson.Array create(int ... values) {
        List<BigDecimal> collect = IntStream.of(values).mapToObj(BigDecimal::new).collect(Collectors.toUnmodifiableList());
        return Hson.Array.createNumbers(collect);
    }

    static Hson.Array create(double ... values) {
        List<BigDecimal> collect = DoubleStream.of(values).mapToObj(String::valueOf).map(BigDecimal::new).collect(Collectors.toUnmodifiableList());
        return Hson.Array.createNumbers(collect);
    }

    static Hson.Array create(float ... values) {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(values.length);
        for (float value : values) {
            list.add(new BigDecimal(String.valueOf(value)));
        }
        return Hson.Array.createNumbers(list);
    }

    @Override
    public List<Hson.Value<?>> value() {
        return this.values;
    }

    @Override
    public void write(PrintWriter metaWriter) {
        metaWriter.write(91);
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i).write(metaWriter);
            if (i >= this.values.size() - 1) continue;
            metaWriter.write(44);
        }
        metaWriter.write(93);
    }

    @Override
    public Hson.Type type() {
        return Hson.Type.ARRAY;
    }

    @Override
    public List<String> getStrings() {
        return this.getTypedList(Hson.Type.STRING);
    }

    @Override
    public List<Boolean> getBooleans() {
        return this.getTypedList(Hson.Type.BOOLEAN);
    }

    @Override
    public List<BigDecimal> getNumbers() {
        return this.getTypedList(Hson.Type.NUMBER);
    }

    @Override
    public List<Hson.Struct> getStructs() {
        return this.getTypedList(Hson.Type.STRUCT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HsonArray)) {
            return false;
        }
        HsonArray jArray = (HsonArray)o;
        return Objects.equals(this.values, jArray.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "[values=" + String.valueOf(this.values) + "]";
    }

    private <T> List<T> getTypedList(Hson.Type type) {
        if (this.values.isEmpty()) {
            return List.of();
        }
        ArrayList list = new ArrayList();
        for (Hson.Value<?> value : this.values) {
            if (value.type() == Hson.Type.NULL) continue;
            if (value.type() != type) {
                throw new HsonException("Requested array of " + String.valueOf((Object)type) + ", but array element is of type: " + String.valueOf((Object)value.type()));
            }
            list.add(value.value());
        }
        return List.copyOf(list);
    }
}

