/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.InstantSource;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;

@QueryScope
public class QuerySystemContractOperations
implements SystemContractOperations {
    private final QueryContext context;
    private final InstantSource instantSource;

    @Inject
    public QuerySystemContractOperations(@NonNull QueryContext queryContext, @NonNull InstantSource instantSource) {
        this.context = Objects.requireNonNull(queryContext);
        this.instantSource = Objects.requireNonNull(instantSource);
    }

    @Override
    @NonNull
    public <T extends StreamBuilder> T dispatch(@NonNull TransactionBody syntheticTransaction, @NonNull VerificationStrategy strategy, @NonNull AccountID syntheticPayerId, @NonNull Class<T> streamBuilderType, @NonNull Set<Key> authorizingKeys, @NonNull DispatchOptions.UsePresetTxnId usePresetTxnId) {
        throw new UnsupportedOperationException("Cannot dispatch synthetic transaction");
    }

    @Override
    public ContractCallStreamBuilder externalizePreemptedDispatch(@NonNull TransactionBody syntheticBody, @NonNull ResponseCodeEnum preemptingStatus, @NonNull HederaFunctionality functionality) {
        throw new UnsupportedOperationException("Cannot externalize preempted dispatch");
    }

    @Override
    @NonNull
    public Predicate<Key> primitiveSignatureTestWith(@NonNull VerificationStrategy strategy) {
        throw new UnsupportedOperationException("Cannot compute a signature test");
    }

    @Override
    @NonNull
    public Predicate<Key> signatureTestWith(@NonNull VerificationStrategy strategy) {
        throw new UnsupportedOperationException("Cannot compute a signature test");
    }

    @Override
    public void externalizeResult(@NonNull ContractFunctionResult result, @NonNull ResponseCodeEnum responseStatus, @Nullable SignedTransaction signedTx, @NonNull EvmTransactionResult txResult) {
    }

    @Override
    public SignedTransaction syntheticSignedTxForNativeCall(@NonNull Bytes input, @NonNull ContractID contractID, boolean isViewCall) {
        return SignedTransaction.DEFAULT;
    }

    @Override
    @NonNull
    public ExchangeRate currentExchangeRate() {
        return this.context.exchangeRateInfo().activeRate(this.instantSource.instant());
    }

    @Override
    @Nullable
    public Key maybeEthSenderKey() {
        return null;
    }
}

