/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.getevmaddressalias;

import com.esaulpaugh.headlong.abi.Address;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.getevmaddressalias.EvmAddressAliasCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EvmAddressAliasTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod EVM_ADDRESS_ALIAS = SystemContractMethod.declare("getEvmAddressAlias(address)", "(int64,address)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALIASES);

    @Inject
    public EvmAddressAliasTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(EVM_ADDRESS_ALIAS);
    }

    @NonNull
    public EvmAddressAliasCall callFrom(@NonNull HasCallAttempt attempt) {
        Address address = (Address)EVM_ADDRESS_ALIAS.decodeCall(attempt.input().toArrayUnsafe()).get(0);
        return new EvmAddressAliasCall(attempt, address);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        return attempt.isMethod(EVM_ADDRESS_ALIAS);
    }
}

