/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.address_0x167;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.CreateCommonDecoder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.CreateSyntheticTxnFactory;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.address_0x167.CreateTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenCreateWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CreateDecoder
extends CreateCommonDecoder {
    @Inject
    public CreateDecoder() {
    }

    @Nullable
    public TransactionBody decodeCreateFungibleTokenV1(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_TOKEN_V1.decodeCall(encoded);
        Tuple hederaToken = (Tuple)call.get(0);
        long initSupply = ((BigInteger)call.get(1)).longValueExact();
        int decimals = ((BigInteger)call.get(2)).intValueExact();
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapper(hederaToken, true, initSupply, decimals, senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateFungibleTokenV2(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_TOKEN_V2.decodeCall(encoded);
        Tuple hederaToken = (Tuple)call.get(0);
        long initSupply = ((BigInteger)call.get(1)).longValueExact();
        int decimals = ((Long)call.get(2)).intValue();
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapper(hederaToken, true, initSupply, decimals, senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateFungibleTokenV3(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_TOKEN_V3.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapper((Tuple)call.get(0), true, (Long)call.get(1), (Integer)call.get(2), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateFungibleTokenWithCustomFeesV1(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_WITH_CUSTOM_FEES_V1.decodeCall(encoded);
        Tuple hederaToken = (Tuple)call.get(0);
        long initSupply = ((BigInteger)call.get(1)).longValueExact();
        int decimals = ((BigInteger)call.get(2)).intValue();
        Tuple[] fixedFee = (Tuple[])call.get(3);
        Tuple[] fractionalFees = (Tuple[])call.get(4);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperFungibleWithCustomFees(hederaToken, initSupply, decimals, fixedFee, fractionalFees, senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateFungibleTokenWithCustomFeesV2(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_WITH_CUSTOM_FEES_V2.decodeCall(encoded);
        Tuple hederaToken = (Tuple)call.get(0);
        long initSupply = ((BigInteger)call.get(1)).longValueExact();
        int decimals = ((Long)call.get(2)).intValue();
        Tuple[] fixedFee = (Tuple[])call.get(3);
        Tuple[] fractionalFees = (Tuple[])call.get(4);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperFungibleWithCustomFees(hederaToken, initSupply, decimals, fixedFee, fractionalFees, senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateFungibleTokenWithCustomFeesV3(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_FUNGIBLE_WITH_CUSTOM_FEES_V3.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperFungibleWithCustomFees((Tuple)call.get(0), (Long)call.get(1), (Integer)call.get(2), (Tuple[])call.get(3), (Tuple[])call.get(4), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleV1(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_V1.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungible((Tuple)call.get(0), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleV2(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_V2.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungible((Tuple)call.get(0), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleV3(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_V3.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungible((Tuple)call.get(0), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleWithCustomFeesV1(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_WITH_CUSTOM_FEES_V1.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungibleWithCustomFees((Tuple)call.get(0), (Tuple[])call.get(1), (Tuple[])call.get(2), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleWithCustomFeesV2(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_WITH_CUSTOM_FEES_V2.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungibleWithCustomFees((Tuple)call.get(0), (Tuple[])call.get(1), (Tuple[])call.get(2), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    public TransactionBody decodeCreateNonFungibleWithCustomFeesV3(@NonNull byte[] encoded, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        Tuple call = CreateTranslator.CREATE_NON_FUNGIBLE_TOKEN_WITH_CUSTOM_FEES_V3.decodeCall(encoded);
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapperNonFungibleWithCustomFees((Tuple)call.get(0), (Tuple[])call.get(1), (Tuple[])call.get(2), senderId, nativeOperations, addressIdConverter);
        return this.bodyFor(tokenCreateWrapper);
    }

    private TokenCreateWrapper getTokenCreateWrapperFungibleWithCustomFees(@NonNull Tuple tokenCreateStruct, long initSupply, int decimals, @NonNull Tuple[] fixedFeesTuple, @NonNull Tuple[] fractionalFeesTuple, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapper(tokenCreateStruct, true, initSupply, decimals, senderId, nativeOperations, addressIdConverter);
        List<TokenCreateWrapper.FixedFeeWrapper> fixedFees = this.decodeFixedFees(fixedFeesTuple, addressIdConverter, nativeOperations.entityIdFactory());
        List<TokenCreateWrapper.FractionalFeeWrapper> fractionalFess = this.decodeFractionalFees(fractionalFeesTuple, addressIdConverter);
        tokenCreateWrapper.setFixedFees(fixedFees);
        tokenCreateWrapper.setFractionalFees(fractionalFess);
        return tokenCreateWrapper;
    }

    private TokenCreateWrapper getTokenCreateWrapperNonFungible(@NonNull Tuple tokenCreateStruct, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        long initSupply = 0L;
        boolean decimals = false;
        return this.getTokenCreateWrapper(tokenCreateStruct, false, 0L, 0, senderId, nativeOperations, addressIdConverter);
    }

    private TokenCreateWrapper getTokenCreateWrapperNonFungibleWithCustomFees(@NonNull Tuple tokenCreateStruct, @NonNull Tuple[] fixedFeesTuple, @NonNull Tuple[] royaltyFeesTuple, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        List<TokenCreateWrapper.FixedFeeWrapper> fixedFees = this.decodeFixedFees(fixedFeesTuple, addressIdConverter, nativeOperations.entityIdFactory());
        List<TokenCreateWrapper.RoyaltyFeeWrapper> royaltyFees = this.decodeRoyaltyFees(royaltyFeesTuple, addressIdConverter, nativeOperations.entityIdFactory());
        long initSupply = 0L;
        boolean decimals = false;
        TokenCreateWrapper tokenCreateWrapper = this.getTokenCreateWrapper(tokenCreateStruct, false, 0L, 0, senderId, nativeOperations, addressIdConverter);
        tokenCreateWrapper.setFixedFees(fixedFees);
        tokenCreateWrapper.setRoyaltyFees(royaltyFees);
        return tokenCreateWrapper;
    }

    @Nullable
    private TransactionBody bodyFor(@NonNull TokenCreateWrapper tokenCreateWrapper) {
        try {
            return this.bodyOf(CreateSyntheticTxnFactory.createToken(tokenCreateWrapper));
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }
}

