/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.freeze;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.token.TokenFreezeAccountTransactionBody;
import com.hedera.hapi.node.token.TokenUnfreezeAccountTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.freeze.FreezeUnfreezeTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FreezeUnfreezeDecoder {
    @Inject
    public FreezeUnfreezeDecoder() {
    }

    public TransactionBody decodeFreeze(@NonNull HtsCallAttempt attempt) {
        Tuple call = FreezeUnfreezeTranslator.FREEZE.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenFreeze(this.freeze(attempt, (Address)call.get(0), (Address)call.get(1))).build();
    }

    public TransactionBody decodeUnfreeze(@NonNull HtsCallAttempt attempt) {
        Tuple call = FreezeUnfreezeTranslator.UNFREEZE.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().tokenUnfreeze(this.unfreeze(attempt, (Address)call.get(0), (Address)call.get(1))).build();
    }

    private TokenFreezeAccountTransactionBody freeze(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Address account) {
        return TokenFreezeAccountTransactionBody.newBuilder().account(attempt.addressIdConverter().convert(account)).token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token)).build();
    }

    private TokenUnfreezeAccountTransactionBody unfreeze(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Address account) {
        return TokenUnfreezeAccountTransactionBody.newBuilder().account(attempt.addressIdConverter().convert(account)).token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token)).build();
    }
}

