/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.ReadableContractStateStore;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;

public class WritableContractStateStore
extends ReadableContractStateStore
implements ContractStateStore {
    private final WritableKVState<SlotKey, SlotValue> storage;
    private final WritableKVState<ContractID, Bytecode> bytecode;
    private final WritableEntityCounters entityCounters;

    public WritableContractStateStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        Objects.requireNonNull(states);
        this.storage = states.get("STORAGE");
        this.bytecode = states.get("BYTECODE");
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    @Override
    public Bytecode getBytecode(@NonNull ContractID contractID) {
        return (Bytecode)this.bytecode.get((Object)Objects.requireNonNull(contractID));
    }

    @Override
    public void putBytecode(@NonNull ContractID contractID, @NonNull Bytecode code) {
        this.bytecode.put((Object)Objects.requireNonNull(contractID), (Object)Objects.requireNonNull(code));
        this.entityCounters.incrementEntityTypeCount(EntityType.CONTRACT_BYTECODE);
    }

    @Override
    public void removeSlot(@NonNull SlotKey key) {
        this.storage.remove((Object)Objects.requireNonNull(key));
    }

    @Override
    public void adjustSlotCount(long delta) {
        this.entityCounters.adjustEntityCount(EntityType.CONTRACT_STORAGE, delta);
    }

    @Override
    public void putSlot(@NonNull SlotKey key, @NonNull SlotValue value) {
        this.storage.put((Object)Objects.requireNonNull(key), (Object)Objects.requireNonNull(value));
    }

    @Override
    public Set<SlotKey> getModifiedSlotKeys() {
        return this.storage.modifiedKeys();
    }

    @Override
    @Nullable
    public SlotValue getSlotValue(@NonNull SlotKey key) {
        return (SlotValue)this.storage.get((Object)Objects.requireNonNull(key));
    }

    @Override
    @Nullable
    public SlotValue getOriginalSlotValue(@NonNull SlotKey key) {
        return (SlotValue)this.storage.getOriginalValue((Object)Objects.requireNonNull(key));
    }
}

