/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.CharSequenceView;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.util.Integers;
import java.util.Arrays;

public final class TypeFactory {
    private static final int MAX_LENGTH_CHARS = 1600;
    private static final int NESTING_LIMIT = 80;
    private static final ABIType<?> STRING;
    private static final ABIType<?> BYTES;
    private static final ABIType<?> BYTES4;
    private static final ABIType<?> BYTES32;
    private static final ABIType<?> LEGACY_STRING;
    private static final ABIType<?> LEGACY_BYTES;
    private static final ABIType<?> LEGACY_BYTES4;
    private static final ABIType<?> LEGACY_BYTES32;
    private static final ABIType<?> BOOL;
    private static final ABIType<?> UINT_256;
    private static final ABIType<?> UINT_8;
    private static final ABIType<?> UINT_32;

    private TypeFactory() {
    }

    public static <T extends ABIType<?>> T create(String rawType) {
        return TypeFactory.create(0, rawType);
    }

    public static <T extends ABIType<?>> T create(int flags, String rawType) {
        return (T)TypeFactory.build(rawType, null, null, flags);
    }

    public static <X extends Tuple> TupleType<X> createTupleTypeWithNames(String rawType, String ... elementNames) {
        return (TupleType)TypeFactory.build(rawType, elementNames, null, 0);
    }

    static ABIType<?> build(String rawType, String[] elementNames, TupleType<?> baseType, int flags) {
        if (rawType.length() > 1600) {
            throw new IllegalArgumentException("type length exceeds maximum: " + rawType.length() + " > " + 1600);
        }
        return TypeFactory.buildUnchecked(new CharSequenceView(rawType), elementNames, baseType, flags);
    }

    private static ABIType<?> buildUnchecked(CharSequenceView rawType, String[] elementNames, TupleType<?> baseType, int flags) {
        block6: {
            try {
                int len = rawType.length();
                if (rawType.charAt(len - 1) == ']') {
                    int arrayOpenIndex = rawType.lastArrayOpen(len - 2);
                    ABIType<?> elementType = TypeFactory.buildUnchecked(rawType.subSequence(0, arrayOpenIndex), null, baseType, flags);
                    String type = new StringBuilder(elementType.canonicalType).append(rawType, arrayOpenIndex, len).toString();
                    int length = arrayOpenIndex == len - 2 ? -1 : TypeFactory.parseArrayLen(rawType, arrayOpenIndex + 1, len - 1);
                    return new ArrayType(type, elementType.arrayClass(), elementType, length, null, flags);
                }
                if (rawType.charAt(0) == '(') {
                    if (baseType != null) {
                        if (len == baseType.canonicalType.length()) {
                            return baseType;
                        }
                        break block6;
                    }
                    return TypeFactory.parseTupleType(rawType, elementNames, flags);
                }
                BigDecimalType t = (flags & 1) != 0 ? UnitType.getLegacy(rawType) : UnitType.get(rawType);
                return t != null ? t : TypeFactory.tryParseFixed(rawType.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw TypeFactory.unrecognizedType(rawType);
    }

    private static IllegalArgumentException unrecognizedType(CharSequenceView rawType) {
        return TypeFactory.unrecognizedType(rawType.toString());
    }

    private static IllegalArgumentException unrecognizedType(String rawType) {
        return new IllegalArgumentException("unrecognized type: \"" + rawType + '\"');
    }

    private static boolean leadDigitValid(char c) {
        return c >= '1' && c <= '9';
    }

    private static int parseArrayLen(CharSequenceView rawType, int i, int end) {
        if (TypeFactory.leadDigitValid(rawType.charAt(i)) || end - i == 1) {
            int d;
            long len = 0L;
            while ((d = rawType.charAt(i) - 48) >= 0 && d <= 9 && (len = len * 10L + (long)d) <= 0x7FFFFFF1L) {
                if (++i != end) continue;
                return (int)len;
            }
        }
        throw new IllegalArgumentException("bad array length");
    }

    private static BigDecimalType tryParseFixed(String rawType) {
        int idx = rawType.indexOf("fixed");
        if (idx == 0 || idx == 1 && rawType.charAt(0) == 'u') {
            int indexOfX = rawType.lastIndexOf(120);
            if (TypeFactory.leadDigitValid(rawType.charAt(idx + "fixed".length())) && TypeFactory.leadDigitValid(rawType.charAt(indexOfX + 1))) {
                try {
                    int M = Integer.parseInt(rawType.substring(idx + "fixed".length(), indexOfX));
                    int N = Integer.parseInt(rawType.substring(indexOfX + 1));
                    if (Integers.isMultiple(M, 8) && M <= 256 && N <= 80) {
                        return new BigDecimalType(rawType, M, N, idx == 1);
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
        throw TypeFactory.unrecognizedType(rawType);
    }

    private static TupleType<?> parseTupleType(CharSequenceView rawType, String[] elementNames, int flags) {
        int len = rawType.length();
        if (len == 2 && rawType.charAt(1) == ')') {
            return TupleType.empty(flags);
        }
        ABIType[] elements = new ABIType[8];
        int argEnd = 1;
        StringBuilder canonicalType = new StringBuilder(len).append('(');
        boolean dynamic = false;
        int i = 0;
        try {
            while (true) {
                int argStart = argEnd;
                ABIType e = null;
                switch (rawType.charAt(argStart)) {
                    case ')': 
                    case ',': {
                        throw TypeFactory.unrecognizedType(rawType);
                    }
                    case '(': {
                        argEnd = TypeFactory.nextTerminator(rawType, TypeFactory.findSubtupleEnd(rawType, argStart + 1));
                        break;
                    }
                    case 'a': {
                        long val = rawType.getFourCharLong(argStart);
                        if (val == CharSequenceView.fourCharLong("addr") && ((val = rawType.getFourCharLong(argStart + 4)) == CharSequenceView.fourCharLong("ess,") || val == CharSequenceView.fourCharLong("ess)"))) {
                            e = AddressType.INSTANCE;
                            argEnd = argStart + "address".length();
                            break;
                        }
                        argEnd = TypeFactory.nextTerminator(rawType, argStart + 1);
                        break;
                    }
                    case 'b': {
                        long val = rawType.getFourCharLong(argStart + 1);
                        if (val == CharSequenceView.fourCharLong("ytes")) {
                            argEnd = TypeFactory.nextTerminator(rawType, argStart + 5);
                            switch (argEnd - argStart) {
                                case 5: {
                                    e = (flags & 1) != 0 ? LEGACY_BYTES : BYTES;
                                    break;
                                }
                                case 6: {
                                    if (rawType.charAt(argStart + 5) != '4') break;
                                    e = (flags & 1) != 0 ? LEGACY_BYTES4 : BYTES4;
                                    break;
                                }
                                case 7: {
                                    if (rawType.charAt(argStart + 5) != '3' || rawType.charAt(argStart + 6) != '2') break;
                                    e = (flags & 1) != 0 ? LEGACY_BYTES32 : BYTES32;
                                }
                            }
                            break;
                        }
                        if (val == CharSequenceView.fourCharLong("ool,") || val == CharSequenceView.fourCharLong("ool)")) {
                            e = BOOL;
                            argEnd = argStart + "bool".length();
                            break;
                        }
                        argEnd = TypeFactory.nextTerminator(rawType, argStart + 1);
                        break;
                    }
                    case 's': {
                        argEnd = TypeFactory.nextTerminator(rawType, argStart + 1);
                        if (argEnd - argStart != "string".length() || rawType.charAt(argStart + 5) != 'g' || rawType.getFourCharLong(argStart + 1) != CharSequenceView.fourCharLong("trin")) break;
                        e = (flags & 1) != 0 ? LEGACY_STRING : STRING;
                        break;
                    }
                    case 'u': {
                        argEnd = TypeFactory.nextTerminator(rawType, argStart + 1);
                        int argLen = argEnd - argStart;
                        if (argLen == 7 && rawType.getFourCharLong(argStart + 1) == CharSequenceView.fourCharLong("int2") && rawType.charAt(argStart + 5) == '5' && rawType.charAt(argStart + 6) == '6') {
                            e = UINT_256;
                            break;
                        }
                        if (rawType.getFourCharLong(argStart) != CharSequenceView.fourCharLong("uint")) break;
                        switch (argLen) {
                            case 4: {
                                e = UINT_256;
                                break;
                            }
                            case 5: {
                                if (rawType.charAt(argStart + 4) != '8') break;
                                e = UINT_8;
                                break;
                            }
                            case 6: {
                                if (rawType.charAt(argStart + 4) != '3' || rawType.charAt(argStart + 5) != '2') break;
                                e = UINT_32;
                            }
                        }
                        break;
                    }
                    default: {
                        argEnd = TypeFactory.nextTerminator(rawType, argStart + 1);
                    }
                }
                if (e == null) {
                    e = TypeFactory.buildUnchecked(rawType.subSequence(argStart, argEnd), null, null, flags);
                }
                canonicalType.append(e.canonicalType);
                dynamic |= e.dynamic;
                elements[i++] = e;
                if (rawType.charAt(argEnd++) == ')') {
                    if (argEnd != len) {
                        throw TypeFactory.unrecognizedType(rawType);
                    }
                    return new TupleType(canonicalType.append(')').toString(), dynamic, Arrays.copyOf(elements, i), elementNames, null, null, flags);
                }
                if (i == elements.length) {
                    elements = Arrays.copyOf(elements, i << 1);
                }
                canonicalType.append(',');
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + i + ", " + iae.getMessage(), iae);
        }
    }

    private static int nextTerminator(CharSequenceView signature, int i) {
        while (true) {
            switch (signature.charAt(i)) {
                case ')': 
                case ',': {
                    return i;
                }
            }
            ++i;
        }
    }

    private static int findSubtupleEnd(CharSequenceView parentTypeString, int i) {
        int depth = 1;
        while (true) {
            switch (parentTypeString.charAt(i++)) {
                case '(': {
                    if (++depth < 80) break;
                    throw new IllegalArgumentException("exceeds nesting limit: 80");
                }
                case ')': {
                    if (depth == 1) {
                        return i;
                    }
                    --depth;
                }
            }
        }
    }

    static {
        UnitType.initInstances();
        STRING = UnitType.get("string");
        BYTES = UnitType.get("bytes");
        BYTES4 = UnitType.get("bytes4");
        BYTES32 = UnitType.get("bytes32");
        LEGACY_STRING = UnitType.getLegacy("string");
        LEGACY_BYTES = UnitType.getLegacy("bytes");
        LEGACY_BYTES4 = UnitType.getLegacy("bytes4");
        LEGACY_BYTES32 = UnitType.getLegacy("bytes32");
        BOOL = UnitType.get("bool");
        UINT_256 = UnitType.get("uint256");
        UINT_8 = UnitType.get("uint8");
        UINT_32 = UnitType.get("uint32");
    }
}

