/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.hash;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.LoggingUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.SerializableHashable;

public final class MerkleHashChecker {
    private static final Logger logger = LogManager.getLogger(MerkleHashChecker.class);
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();

    private MerkleHashChecker() {
    }

    public static void findInvalidHashes(MerkleCryptography merkleCryptography, MerkleNode root, Consumer<MerkleNode> mismatchCallback) {
        if (root == null) {
            return;
        }
        root.forEachNode(node -> MerkleHashChecker.findInvalidHash(merkleCryptography, node, mismatchCallback));
    }

    private static void findInvalidHash(MerkleCryptography merkleCryptography, MerkleNode node, Consumer<MerkleNode> mismatchCallback) {
        Hash recalculated;
        if (node == null || node.isSelfHashing()) {
            return;
        }
        Hash old = node.getHash();
        if (old == null) {
            mismatchCallback.accept(node);
            return;
        }
        if (node.isLeaf()) {
            recalculated = CRYPTOGRAPHY.digestSync((SerializableHashable)node, false);
        } else {
            MerkleInternal internal = node.asInternal();
            for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
                MerkleNode child = internal.getChild(childIndex);
                if (child == null || child.getHash() != null) continue;
                return;
            }
            recalculated = merkleCryptography.digestSync(internal, false);
        }
        if (!old.equals((Object)recalculated)) {
            mismatchCallback.accept(node);
        }
    }

    public static List<MerkleNode> getNodesWithInvalidHashes(MerkleCryptography merkleCryptography, MerkleNode root) {
        LinkedList<MerkleNode> nodesWithInvalidHashes = new LinkedList<MerkleNode>();
        MerkleHashChecker.findInvalidHashes(merkleCryptography, root, nodesWithInvalidHashes::add);
        return nodesWithInvalidHashes;
    }

    public static boolean checkHashAndLog(MerkleCryptography merkleCryptography, MerkleNode root, String context, int limit) {
        List<MerkleNode> nodesWithInvalidHashes = MerkleHashChecker.getNodesWithInvalidHashes(merkleCryptography, root);
        if (nodesWithInvalidHashes.isEmpty()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid merkle hashes detected in tree. Context = ").append(context).append("\n");
        int nodesWithNullHash = 0;
        int nodesWithInvalidHash = 0;
        for (MerkleNode node : nodesWithInvalidHashes) {
            if (node.getHash() == null) {
                ++nodesWithNullHash;
                continue;
            }
            ++nodesWithInvalidHash;
        }
        sb.append(nodesWithNullHash).append(" ").append(LoggingUtils.plural((long)nodesWithNullHash, (String)"node")).append(" ").append(LoggingUtils.plural((long)nodesWithNullHash, (String)"has a null hash", (String)"have null hashes")).append(". ");
        sb.append(nodesWithInvalidHash).append(" ").append(LoggingUtils.plural((long)nodesWithInvalidHash, (String)"node")).append(" ").append(LoggingUtils.plural((long)nodesWithInvalidHash, (String)"has an invalid hash", (String)"have invalid hashes")).append(".\n");
        if (nodesWithInvalidHashes.size() > limit) {
            sb.append("Number of nodes exceeds maximum limit, only logging the first ").append(limit).append(" ").append(LoggingUtils.plural((long)limit, (String)"node")).append(".\n");
        }
        int count = 0;
        for (MerkleNode node : nodesWithInvalidHashes) {
            if (++count > limit) break;
            sb.append("   - ").append(node.getClass().getSimpleName()).append(" @ ").append(node.getRoute()).append(" ");
            if (node.getHash() == null) {
                sb.append("has a null hash");
            } else {
                sb.append("has an invalid hash");
            }
            sb.append("\n");
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), (CharSequence)sb);
        return false;
    }
}

