/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.output.codec;

import com.hedera.hapi.block.stream.output.TransactionResult;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransactionResultJsonCodec
implements JsonCodec<TransactionResult> {
    @NonNull
    public TransactionResult parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ResponseCodeEnum temp_status = ResponseCodeEnum.fromProtobufOrdinal(0);
            Timestamp temp_consensus_timestamp = null;
            Timestamp temp_parent_consensus_timestamp = null;
            ScheduleID temp_schedule_ref = null;
            long temp_transaction_fee_charged = 0L;
            TransferList temp_transfer_list = null;
            List temp_token_transfer_lists = Collections.emptyList();
            List temp_automatic_token_associations = Collections.emptyList();
            List temp_paid_staking_rewards = Collections.emptyList();
            long temp_congestion_pricing_multiplier = 0L;
            List temp_assessed_custom_fees = Collections.emptyList();
            block28: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "status": {
                        temp_status = ResponseCodeEnum.fromString(kvPair.value().STRING().getText());
                        continue block28;
                    }
                    case "consensusTimestamp": {
                        temp_consensus_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block28;
                    }
                    case "parentConsensusTimestamp": {
                        temp_parent_consensus_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block28;
                    }
                    case "scheduleRef": {
                        temp_schedule_ref = (ScheduleID)ScheduleID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block28;
                    }
                    case "transactionFeeCharged": {
                        temp_transaction_fee_charged = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block28;
                    }
                    case "transferList": {
                        temp_transfer_list = (TransferList)TransferList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block28;
                    }
                    case "tokenTransferLists": {
                        temp_token_transfer_lists = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenTransferList.JSON, (int)(maxDepth - 1));
                        continue block28;
                    }
                    case "automaticTokenAssociations": {
                        temp_automatic_token_associations = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), TokenAssociation.JSON, (int)(maxDepth - 1));
                        continue block28;
                    }
                    case "paidStakingRewards": {
                        temp_paid_staking_rewards = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), AccountAmount.JSON, (int)(maxDepth - 1));
                        continue block28;
                    }
                    case "congestionPricingMultiplier": {
                        temp_congestion_pricing_multiplier = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block28;
                    }
                    case "assessedCustomFees": {
                        temp_assessed_custom_fees = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), AssessedCustomFee.JSON, (int)(maxDepth - 1));
                        continue block28;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TransactionResult(temp_status, temp_consensus_timestamp, temp_parent_consensus_timestamp, temp_schedule_ref, temp_transaction_fee_charged, temp_transfer_list, temp_token_transfer_lists, temp_automatic_token_associations, temp_paid_staking_rewards, temp_congestion_pricing_multiplier, temp_assessed_custom_fees);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TransactionResult data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.status() != ResponseCodeEnum.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"status", (String)data.status().protoName()));
        }
        if (data.consensusTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"consensusTimestamp", Timestamp.JSON, (Object)data.consensusTimestamp()));
        }
        if (data.parentConsensusTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"parentConsensusTimestamp", Timestamp.JSON, (Object)data.parentConsensusTimestamp()));
        }
        if (data.scheduleRef() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleRef", ScheduleID.JSON, (Object)data.scheduleRef()));
        }
        if (data.transactionFeeCharged() != 0L) {
            fieldLines.add(JsonTools.field((String)"transactionFeeCharged", (long)data.transactionFeeCharged()));
        }
        if (data.transferList() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"transferList", TransferList.JSON, (Object)data.transferList()));
        }
        if (!data.tokenTransferLists().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"tokenTransferLists", TokenTransferList.JSON, data.tokenTransferLists()));
        }
        if (!data.automaticTokenAssociations().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"automaticTokenAssociations", TokenAssociation.JSON, data.automaticTokenAssociations()));
        }
        if (!data.paidStakingRewards().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"paidStakingRewards", AccountAmount.JSON, data.paidStakingRewards()));
        }
        if (data.congestionPricingMultiplier() != 0L) {
            fieldLines.add(JsonTools.field((String)"congestionPricingMultiplier", (long)data.congestionPricingMultiplier()));
        }
        if (!data.assessedCustomFees().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"assessedCustomFees", AssessedCustomFee.JSON, data.assessedCustomFees()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

