/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public abstract class ReadableSingletonStateBase<T>
implements ReadableSingletonState<T> {
    private boolean read = false;
    protected final String serviceName;
    protected final String stateKey;

    public ReadableSingletonStateBase(@NonNull String serviceName, @NonNull String stateKey) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.stateKey = Objects.requireNonNull(stateKey);
    }

    @Override
    @NonNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @Override
    @NonNull
    public final String getStateKey() {
        return this.stateKey;
    }

    @Override
    public T get() {
        T value = this.readFromDataSource();
        this.read = true;
        return value;
    }

    protected abstract T readFromDataSource();

    @Override
    public boolean isRead() {
        return this.read;
    }

    public void reset() {
        this.read = false;
    }
}

