/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.VersionedHash;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class BlobHashOperation
extends AbstractOperation {
    public static final int OPCODE = 73;

    public BlobHashOperation(GasCalculator gasCalculator) {
        super(73, "BLOBHASH", 1, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Bytes versionedHashIndexParam = frame.popStackItem();
        if (frame.getVersionedHashes().isPresent()) {
            List<VersionedHash> versionedHashes = frame.getVersionedHashes().get();
            Bytes trimmedIndex = versionedHashIndexParam.trimLeadingZeros();
            if (trimmedIndex.size() > 4) {
                frame.pushStackItem(Bytes.EMPTY);
                return new Operation.OperationResult(3L, null);
            }
            int versionedHashIndex = trimmedIndex.toInt();
            if (versionedHashIndex < versionedHashes.size() && versionedHashIndex >= 0) {
                VersionedHash requested = versionedHashes.get(versionedHashIndex);
                frame.pushStackItem((Bytes)requested.toBytes());
            } else {
                frame.pushStackItem(Bytes.EMPTY);
            }
        } else {
            frame.pushStackItem(Bytes.EMPTY);
        }
        return new Operation.OperationResult(3L, null);
    }
}

