/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class TStoreOperation
extends AbstractOperation {
    public TStoreOperation(GasCalculator gasCalculator) {
        super(93, "TSTORE", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        UInt256 key = UInt256.fromBytes((Bytes)frame.popStackItem());
        UInt256 value = UInt256.fromBytes((Bytes)frame.popStackItem());
        long cost = this.gasCalculator().getTransientStoreOperationGasCost();
        long remainingGas = frame.getRemainingGas();
        if (frame.isStatic()) {
            return new Operation.OperationResult(remainingGas, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (remainingGas < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.setTransientStorageValue(frame.getRecipientAddress(), (Bytes32)key, (Bytes32)value);
        return new Operation.OperationResult(cost, null);
    }
}

