/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class SHA256PrecompiledContract
extends AbstractPrecompiledContract {
    public SHA256PrecompiledContract(GasCalculator gasCalculator) {
        super("SHA256", gasCalculator);
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCalculator().sha256PrecompiledContractGasCost(input);
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        return PrecompiledContract.PrecompileContractResult.success((Bytes)Hash.sha256((Bytes)input));
    }
}

