/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.builder.api.Prototype;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriPath;

final class UriBuilderSupport {
    private UriBuilderSupport() {
    }

    static final class UriInfoCustomMethods {
        private UriInfoCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void authority(UriInfo.BuilderBase<?, ?> builder, String authority) {
            int index = authority.lastIndexOf(58);
            if (index < 1) {
                builder.host(authority);
                return;
            }
            if (authority.charAt(authority.length() - 1) == ']') {
                builder.host(authority);
                return;
            }
            builder.host(authority.substring(0, index));
            builder.port(Integer.parseInt(authority.substring(index + 1)));
        }

        @Prototype.BuilderMethod
        static void path(UriInfo.BuilderBase<?, ?> builder, String path) {
            builder.path(UriPath.createFromDecoded(path));
        }
    }

    static final class UriInfoInterceptor
    implements Prototype.BuilderDecorator<UriInfo.BuilderBase<?, ?>> {
        UriInfoInterceptor() {
        }

        public void decorate(UriInfo.BuilderBase<?, ?> target) {
            if (target.port() == 0) {
                target.port(UriInfoInterceptor.defaultPort(target.scheme()));
            }
        }

        private static int defaultPort(String scheme) {
            if ("http".equals(scheme)) {
                return 80;
            }
            if ("https".equals(scheme)) {
                return 443;
            }
            if (scheme.charAt(scheme.length() - 1) == 's') {
                return 443;
            }
            return 80;
        }
    }
}

