/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.diagram;

import edu.umd.cs.findbugs.annotations.NonNull;

public final class HyperlinkBuilder {
    public static final String PLATFORM_CORE_ROOT = "https://github.com/hashgraph/hedera-services/blob/main/platform-sdk/swirlds-platform-core/src/main/java";
    public static final String PLATFORM_COMMON_ROOT = "https://github.com/hashgraph/hedera-services/blob/main/platform-sdk/swirlds-common/src/main/java";

    public static String platformCoreHyperlink(@NonNull Class<?> clazz) {
        return HyperlinkBuilder.buildHyperlink(PLATFORM_CORE_ROOT, clazz);
    }

    public static String platformCommonHyperlink(@NonNull Class<?> clazz) {
        return HyperlinkBuilder.buildHyperlink(PLATFORM_COMMON_ROOT, clazz);
    }

    @NonNull
    public static String buildHyperlink(@NonNull String root, @NonNull Class<?> clazz) {
        String className = clazz.getName();
        String[] parts = className.split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append(root);
        if (!root.endsWith("/")) {
            sb.append("/");
        }
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= parts.length - 1) continue;
            sb.append("/");
        }
        sb.append(".java");
        return sb.toString();
    }
}

