/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui;

import com.swirlds.common.Console;
import com.swirlds.platform.gui.GuiConstants;
import com.swirlds.platform.gui.WindowConfig;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.components.ScrollableJPanel;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public final class GuiUtils {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");

    private GuiUtils() {
    }

    public static String wrap(int len, String str) {
        String[] lines;
        StringBuilder ans = new StringBuilder();
        for (String line : lines = str.split("\n")) {
            if (line.length() == 0) {
                ans.append('\n');
            }
            char[] c = line.toCharArray();
            int i = 0;
            while (i < c.length) {
                int j = i + len;
                if (j >= c.length) {
                    j = c.length;
                } else if (Character.isWhitespace(c[j])) {
                    while (j < c.length && Character.isWhitespace(c[j])) {
                        ++j;
                    }
                } else {
                    while (j >= i && !Character.isWhitespace(c[j])) {
                        --j;
                    }
                    j = j < i ? i + len : ++j;
                }
                ans.append(c, i, j - i);
                ans.append('\n');
                i = j;
            }
        }
        return ans.substring(0, ans.length() - 1);
    }

    public static JTextArea newJTextArea(String text) {
        JTextArea txt = new JTextArea(0, 0);
        ((DefaultCaret)txt.getCaret()).setUpdatePolicy(1);
        txt.setBackground(Color.WHITE);
        txt.setForeground(Color.BLACK);
        txt.setDisabledTextColor(Color.BLACK);
        txt.setFont(GuiConstants.FONT);
        txt.setEditable(false);
        txt.setEnabled(false);
        txt.setText(text);
        txt.setVisible(true);
        return txt;
    }

    public static Rectangle winRect(int winCount, int winNum) {
        int leftGap = IS_WINDOWS ? 0 : 25;
        int rightGap = IS_WINDOWS ? 50 : 0;
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int contentWidth = (screenSize.width - leftGap - rightGap - WindowConfig.getInsets().left - WindowConfig.getInsets().right) / winCount;
        int x = screenSize.x + leftGap + contentWidth * winNum;
        int y = screenSize.y;
        int width = contentWidth + WindowConfig.getInsets().left + WindowConfig.getInsets().right;
        int height = screenSize.height;
        return new Rectangle(x, y, width, height);
    }

    public static WindowAdapter stopper() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SystemExitUtils.exitSystem(SystemExitCode.NO_ERROR, "window closed", true);
            }
        };
    }

    public static ScrollableJPanel makeScrollableJPanel(PrePaintableJPanel comp) {
        comp.setBackground(Color.WHITE);
        ScrollableJPanel scroll = new ScrollableJPanel(comp);
        scroll.setBackground(Color.WHITE);
        scroll.setVisible(true);
        return scroll;
    }

    public static JPanel createPairPanel(JPanel controls, JPanel picture) {
        JPanel pairPanel = new JPanel();
        pairPanel.setLayout(new GridBagLayout());
        pairPanel.setBackground(Color.WHITE);
        pairPanel.setVisible(true);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 23;
        c3.gridx = 0;
        c3.gridy = 0;
        c3.gridwidth = -1;
        c3.gridheight = 0;
        c3.fill = 1;
        c3.weightx = 0.0;
        c3.weighty = 0.0;
        pairPanel.add((Component)controls, c3);
        c3.gridx = 1;
        c3.gridwidth = 0;
        c3.gridheight = 0;
        c3.weightx = 1.0;
        c3.weighty = 1.0;
        c3.fill = 1;
        pairPanel.add((Component)picture, c3);
        JPanel spacer = new JPanel();
        spacer.setBackground(Color.YELLOW);
        spacer.setVisible(true);
        picture.setVisible(true);
        return pairPanel;
    }

    public static JFrame createBasicWindow(String name, Rectangle winRect, boolean visible) {
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.setBackground(Color.DARK_GRAY);
        frame.setSize(winRect.width, winRect.height);
        frame.setPreferredSize(new Dimension(winRect.width, winRect.height));
        frame.setLocation(winRect.x, winRect.y);
        frame.setFocusable(true);
        frame.requestFocusInWindow();
        frame.setVisible(visible);
        return frame;
    }

    public static Console createBasicConsole(String name, Rectangle winRect, boolean visible) {
        Console console = new Console(name, winRect);
        console.getWindow().setDefaultCloseOperation(2);
        console.setVisible(visible);
        return console;
    }
}

